% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_integral3d_work.R
\name{line_integral3d_work}
\alias{line_integral3d_work}
\title{3D line integral with work visualization}
\usage{
line_integral3d_work(
  field,
  r,
  a,
  b,
  plot = TRUE,
  n_curve = 600,
  n_field = 7,
  field_ranges = NULL,
  pad = 0.15,
  arrows = c("both", "line", "cone", "none"),
  arrow_scale = 0.1,
  normalize_bias = 1,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{field}{Function that represents the vector field. It must be a function
of three or four numeric arguments. In the three argument form the
arguments are x, y and z. In the four argument form the arguments are
x, y, z and t. The function must return a numeric vector of length three.}

\item{r}{Function of one numeric argument t that returns a numeric vector
c(x, y, z) of length three with the coordinates of the curve.}

\item{a}{Numeric scalar with the lower value of the parameter interval.}

\item{b}{Numeric scalar with the upper value of the parameter interval.
It must satisfy \code{b > a}.}

\item{plot}{Logical value. If \code{TRUE}, a plotly object with the field
arrows and the curve is created.}

\item{n_curve}{Integer number of sampled points on the curve.}

\item{n_field}{Integer number of grid points per axis for the field
arrows. The total number of arrows is \code{n_field^3}.}

\item{field_ranges}{Optional list with named components \code{x}, \code{y}
and \code{z}, each a numeric vector of length two giving the range used
to build the field grid. If \code{NULL}, the ranges are taken from the
bounding box of the curve and expanded by \code{pad}.}

\item{pad}{Numeric fraction used to expand the automatic field ranges.}

\item{arrows}{Character string that selects which arrow style is drawn.
One of \code{"both"}, \code{"line"}, \code{"cone"} or \code{"none"}.}

\item{arrow_scale}{Numeric factor that controls the length of the arrows
as a fraction of the size of the domain.}

\item{normalize_bias}{Numeric value used to regularize the scaling of
the field magnitude when computing arrows.}

\item{scene}{List of plotly scene options passed to \code{plotly::layout()}.}

\item{bg}{List with two character elements named \code{paper} and
\code{plot} that control the background colours in the plotly layout.}
}
\value{
A list with components:
\itemize{
\item \code{value}: numeric value of the line integral (work).
\item \code{fig}: plotly object when \code{plot = TRUE}, otherwise
\code{NULL}.
\item \code{field_box}: list with numeric ranges used for the field
grid, with components \code{x}, \code{y} and \code{z}.
}
}
\description{
Compute a numerical approximation of the line integral of a vector field
along a parametric space curve and optionally draw a three dimensional
visualization of the curve together with arrows of the field.
}
\details{
The parameter t runs from a to b. The curve r(t) must return a numeric
vector of length three. The field field(x, y, z) may optionally also depend
on t through a fourth argument.
}
\examples{
\donttest{
field <- function(x, y, z) c(-y, x, 0.2*z)
r <- function(t) c(cos(t), sin(t), 0.25*t)
out <- line_integral3d_work(
  field = field, r = r, a = 0, b = 2*pi,
  plot = FALSE, n_curve = 200, n_field = 5
)
out$value
}

}
