% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf-tables.R
\name{subset.vcftable}
\alias{subset.vcftable}
\title{Subset a vcftable object}
\usage{
\method{subset}{vcftable}(x, subset, select, drop = FALSE, ...)
}
\arguments{
\item{x}{a vcftable object returned by \code{\link{vcftable}}}

\item{subset}{logical expression indicating variants (rows) to keep.
The expression is evaluated in the context of the vcftable object,
allowing direct reference to fields like chr, pos, ref, alt, qual, etc.
Missing values are treated as FALSE.}

\item{select}{expression indicating which fields (columns) to select.
If omitted, all fields except samples are selected.
Note: the samples field is always kept and cannot be selected/deselected.}

\item{drop}{logical. If TRUE, the result is coerced to the lowest possible dimension.
Passed to the [ operator when subsetting. Default FALSE.}

\item{...}{Currently not used but can avoid S3 generic consistency warnings}
}
\value{
A vcftable object with the selected variants and fields.
}
\description{
S3 method for subsetting vcftable objects by rows (variants) and columns (fields).
Allows filtering variants based on logical conditions and selecting specific fields.
}
\examples{
library('vcfppR')
vcffile <- system.file("extdata", "raw.gt.vcf.gz", package="vcfppR")
res <- vcftable(vcffile, "chr21:1-5050000")

# Subset by quality score
high_qual <- subset(res, qual > 100)

# Subset by position and select specific fields
region_subset <- subset(res, pos >= 5000000 & pos <= 5010000,
                        select = c(chr, pos, ref, alt))

region_subset <- subset(res, pos >= 5000000 & pos <= 5030400,
                        select = c(chr, pos, ref, alt))

# Subset SNPs (REF and ALT are single nucleotides)
snps <- subset(res, nchar(ref) == 1 & nchar(alt) == 1)

}
\author{
Zilong Li \email{zilong.dk@gmail.com}
}
