% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_levels_transformator.R
\name{merge_levels_transformator}
\alias{merge_levels_transformator}
\title{Combine levels of a variable into one level}
\usage{
merge_levels_transformator(dataname)
}
\arguments{
\item{dataname}{(\code{character(1)}) the name of the dataset
which columns will be used for possible transformation.}
}
\value{
\code{teal::teal_transform_module}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This transformator allows the user to select a column from the dataset
and combine values of this column into a single level. Only selected
levels are affected.

The new combined level is called "Combined".

Merging works only for \code{character} or \code{factor} columns.
}
\examples{

app <- teal::init(
  data = teal.data::teal_data(IRIS = iris, code = "IRIS <- iris"),
  modules = teal::modules(
    teal::example_module(
      transformators = list(uteals::merge_levels_transformator("IRIS"))
    )
  )
)
if (interactive()) {
  shiny::shinyApp(app$ui, app$server)
}

}
