% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_plot_format}
\alias{umx_set_plot_format}
\title{Set output format of plots (structural diagrams) in umx}
\usage{
umx_set_plot_format(umx.plot.format = NULL, silent = FALSE)
}
\arguments{
\item{umx.plot.format}{format for plots (if empty, returns the current value of umx.plot.format). If "TRUE", then toggles}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
\itemize{
\item Current umx.plot.format setting
}
}
\description{
Set output format of plots (default = "\code{\link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR()}}", alternatives are graphviz, svg, png, pdf). If you call this with no
value, it will return the current setting. If you call it with TRUE, it toggles the setting.
}
\examples{
library(umx)
umx_set_plot_format() # print current state
old = umx_set_plot_format(silent = TRUE) # store current value
umx_set_plot_format("graphviz")
umx_set_plot_format("DiagrammeR")
umx_set_plot_format("png")
umx_set_plot_format("pdf")
umx_set_plot_format(old) # reinstate
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Get and set: 
\code{\link{umx}},
\code{\link{umx_get_alphas}()},
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_dollar_symbol}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_silent}()},
\code{\link{umx_set_table_format}()}
}
\concept{Get and set}
