% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_heteroatoms.R
\name{uplot_heteroatoms}
\alias{uplot_heteroatoms}
\title{Heteroatom Combination vs Mass Accuracy}
\usage{
uplot_heteroatoms(df, col = "grey", gg_size = 12, logo = TRUE, plotly = FALSE)
}
\arguments{
\item{df}{A \code{data.table} containing at least:
\itemize{
\item \code{nsp_type}: character or factor indicating heteroatom combinations
\item \code{ppm}: numeric mass accuracy values
}}

\item{col}{Character. Box color. Default \code{"grey"}.}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}
}
\value{
A ggplot or plotly interactive boxplot.
}
\description{
Produces a boxplot visualizing the distribution of mass accuracy (\code{ppm})
for different heteroatom combinations (\code{nsp_type}) defined by the number
of nitrogen (N), sulfur (S), and phosphorus (P) atoms in each formula.

The plot can be returned as either a ggplot object or as an interactive
plotly object (\code{plotly = TRUE}). An optional “UltraMassExplorer”
watermark can be added.
}
\examples{
uplot_heteroatoms(mf_data_demo)

}
\seealso{
Other plots: 
\code{\link{uplot_cluster}()},
\code{\link{uplot_cvm}()},
\code{\link{uplot_dbe_minus_o_freq}()},
\code{\link{uplot_dbe_vs_c}()},
\code{\link{uplot_freq_ma}()},
\code{\link{uplot_freq_vs_ppm}()},
\code{\link{uplot_hc_vs_m}()},
\code{\link{uplot_isotope_precision}()},
\code{\link{uplot_kmd}()},
\code{\link{uplot_lcms}()},
\code{\link{uplot_ma_vs_mz}()},
\code{\link{uplot_ms}()},
\code{\link{uplot_n_mf_per_sample}()},
\code{\link{uplot_pca}()},
\code{\link{uplot_ratios}()},
\code{\link{uplot_reproducibility}()},
\code{\link{uplot_ri_vs_sample}()},
\code{\link{uplot_vk}()}
}
\concept{plots}
