% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_xml_peaklist.R
\name{read_xml_peaklist}
\alias{read_xml_peaklist}
\title{Read xml peaklists generates ultrahigh-resolution MS analyses}
\usage{
read_xml_peaklist(folder_path = NULL, ...)
}
\arguments{
\item{folder_path}{(Optional) The path to the directory containing the XML files.
If not provided, the user will be prompted to choose a folder path interactively.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \code{data.table} containing the combined peaklists extracted from all XML files
in the selected folder. Each row represents a single peak. The table includes:

\itemize{
\item \code{filename} – name of the XML file from which the peak originates.
\item \code{mz} – mass-to-charge ratio of the peak.
\item \code{sn} – signal-to-noise ratio (if available in the XML).
\item \code{res} – peak resolution (if available in the XML).
\item \code{i_magnitude} – peak intensity.
}

Files that contain no peak entries return a row with \code{filename} only.
If the package \code{xml2} is not installed, the function returns \code{NULL}
after printing an informative message.
}
\description{
This function reads multiple FTMS peaklist files in XML format. The function requires the package 'xml2'.
that are generated from Bruker FTICRMS and Thermo Orbitrap instruments.
A single peaklists containing the file_paths is returned as a data.table
A dialog window requests the path to the required directory (recursive = FALSE by default).
}
\seealso{
Other internal functions: 
\code{\link{create_custom_formula_library}()},
\code{\link{extract_aquisition_params}()},
\code{\link{extract_aquisition_params_from_folder}()},
\code{\link{extract_metadata_from_ufz_files}()}
}
\concept{internal functions}
\keyword{internal}
\keyword{misc}
