% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_isotopes.R
\name{eval_isotopes}
\alias{eval_isotopes}
\title{Evaluate isotope information}
\usage{
eval_isotopes(mfd, remove_isotopes = TRUE, verbose = FALSE, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{remove_isotopes}{If set to TRUE (default), all entries for isotopologues are removed from mfd.
The main isotope information for each parent ion is still maintained in the "intxy"-columns.}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A data.table with additional columns such as "int_13c" containing stable isotope abundance information.
}
\description{
Add isotope information to the parent mass and optionally remove isotopoloques from mfd table.
Required for further data evaluation that considers isotope information.
}
\examples{
eval_isotopes(mfd = mf_data_demo)
}
\seealso{
Other Formula assignment: 
\code{\link{add_known_mf}()},
\code{\link{calc_eval_params}()},
\code{\link{check_formula_library}()},
\code{\link{ume_assign_formulas}()}
}
\author{
Boris P. Koch
}
\concept{Formula assignment}
