% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_neutral_mass.R
\name{calc_neutral_mass}
\alias{calc_neutral_mass}
\title{Calculate neutral molecular mass}
\usage{
calc_neutral_mass(mz, pol = c("neg", "pos", "neutral"), ...)
}
\arguments{
\item{mz}{Numeric vector of m/z values (> 0).}

\item{pol}{Character: \code{"neg"}, \code{"pos"}, or \code{"neutral"}.}

\item{...}{Additional arguments passed to methods.}
}
\value{
Numeric vector of neutral masses.
}
\description{
Calculates neutral molecular masses for singly charged ions with full numerical
precision. No user options are modified.

The conversion used is:
\itemize{
\item negative mode: m = mz + 1.0072763
\item positive mode: m = mz - 1.0072763
\item neutral:       m = mz
}
}
\examples{
calc_neutral_mass(199.32, pol = "neg")

}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\concept{calculations}
