% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweedie_dev.R
\name{tweedie_dev}
\alias{tweedie_dev}
\alias{tweedie.dev}
\title{Unit Deviance for a Tweedie Distribution}
\usage{
tweedie_dev(y, mu, power)

tweedie.dev(y, mu, power)
}
\arguments{
\item{y}{vector of quantiles.}

\item{mu}{the mean parameter \eqn{\mu}{mu}.}

\item{power}{the power parameter \eqn{p}{power}.}
}
\value{
A numeric vector containing the unit deviance.
}
\description{
Computes the unit deviance for Tweedie distributions.
}
\examples{
# Unit deviance is not symmetric in general:
round( tweedie_dev(0:6, mu = 3, power = 1.1), 3)

}
\references{
Jorgensen, B. (1997).
\emph{Theory of Dispersion Models}.
Chapman and Hall, London.
}
