% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweedie_convert.R
\name{tweedie_convert}
\alias{tweedie_convert}
\alias{tweedie.convert}
\title{Tweedie Distribution: Convert Between Parameter Formats}
\usage{
tweedie_convert(xi = NULL, mu, phi, power = NULL)

tweedie.convert(xi = NULL, mu, phi, power = NULL)
}
\arguments{
\item{xi}{a synonym for \code{power}.}

\item{mu}{the mean parameter \eqn{\mu}{mu}.}

\item{phi}{the dispersion parameter \eqn{\phi}{phi}.}

\item{power}{the power parameter \eqn{p}{power}; a synonym for \eqn{\xi}{xi}.}
}
\value{
a list of the parameters of the parameters of the corresponding underlying 
Poisson and gamma densities: 
\code{poisson.lambda} (\eqn{\lambda}{lambda} from the underlying Poisson distribution),
\code{gamma.shape}, \code{gamma.scale} (the shape and scale parameters
 from the underlying gamma distribution),
 \code{p0} (the probability that \eqn{Y = 0}),
 \code{gamma.mean} and \code{gamma.phi} (the gamma mean and dispersion parameter values)
}
\description{
Converts from the fitted \acronym{glm} parameters \eqn{p}, \eqn{\mu}{mu} and \eqn{\phi}{phi}
and the corresponding underlying Poisson and gamma parameters (when \eqn{1 < p < 2}).
}
\examples{
### Fit a Tweedie density
pretend <- data.frame( y = rgamma(20, shape = 1, rate = 1) )
fit <- glm(y ~ 1, data = pretend, 
           family = statmod::tweedie(link.power = 0, var.power = 1.4))

# Convert parameters
tweedie_convert(mu = fitted(fit, type="response"), phi = 1, power = 1.4)

}
