% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.1.R
\name{tsmltest}
\alias{tsmltest}
\title{McLeod-Li Test for ARCH Effect}
\usage{
tsmltest(object, lag.max = NULL)
}
\arguments{
\item{object}{a univariate time series object or a numeric vector or matrix.}

\item{lag.max}{maximum lag at which to examine the ARCH effect. Default is \code{NULL}. Will be automatically calculated using the formula \eqn{10\cdot \log_{10}(n)}, where \eqn{n} is the series length, if the parameter is omitted.}
}
\value{
A list with two elements:

\item{\code{test.value}}{chi-square test statistics of the McLeod-Li test for the lags 1 to \code{lag.max}.}

\item{\code{p.value}}{corresponding p-values of the McLeod-Li test for the lags 1 to \code{lag.max}.}
}
\description{
The function `\code{tsmltest}` applies the McLeod-Li test to examine whether ARCH effect exists in the squared residuals of an ARIMA model.
}
\examples{
tsmltest(tsarima(airport$Travellers, order = c(1, 1, 0), 
                 seasonal = c(0, 1, 1), log = TRUE, include.const = TRUE))
}
\references{
McLeod, A. I., & Li, W. K. (1983). Diagnostic Checking ARMA Time Series Models Using Squared-Residual Autocorrelations. \emph{Journal of Time Series Analysis}, \strong{4}(4), 269-273. \cr \doi{10.1111/j.1467-9892.1983.tb00373.x}.
}
\author{
Ka Yui Karl Wu
}
