% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_number.r
\name{pretty_number}
\alias{pretty_number}
\title{Convert Numbers into Readable Abbreviated Formats}
\usage{
pretty_number(
  x,
  digits = 2,
  n_decimal = deprecated(),
  prefix = NULL,
  truncate = FALSE
)
}
\arguments{
\item{x}{A numeric value or vector to be converted into a readable format.}

\item{digits}{Number of decimal places to display. Defaults to 2.}

\item{n_decimal}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{digits} instead.}

\item{prefix}{An optional character string to prepend to the formatted number
(e.g., "$"). Defaults to \code{NULL}.}

\item{truncate}{A logical value indicating whether to truncate the numbers
before formatting. When \code{TRUE}, the function uses \code{base::signif()} to
truncate the numbers to the specified number of significant digits, making
the output more concise. When \code{FALSE}, the function uses \code{base::round()} to
round the numbers to the specified number of decimal places, preserving the
original scale of the number. Defaults to \code{FALSE}.}
}
\value{
A character vector with the numbers formatted as abbreviated
strings. If \code{prefix} is provided, it prepends the formatted numbers.
}
\description{
This function converts large numeric values into readable abbreviated formats
(e.g., 1,000 becomes "1k") with options for rounding, decimal precision, and
a custom prefix. It supports numbers up to the decillion range.
}
\examples{
# Basic usage
pretty_number(1234)               # "1.23k"
pretty_number(1234567)            # "1.23m"
pretty_number(1234567890)         # "1.23b"

# Adjusting decimal places
pretty_number(1234, digits = 1) # "1.2k"

# Adding a prefix
pretty_number(1234, prefix = "$")  # "$1.23k"

# Without rounding
pretty_number(1250, truncate = TRUE) # "1.2k"

}
\author{
Nicolas Foss, Ed.D., MS
}
