% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_findingemo.R
\name{load_findingemo_annotations}
\alias{load_findingemo_annotations}
\title{Load FindingEmo-Light Annotations}
\usage{
load_findingemo_annotations(
  data_dir,
  output_format = c("dataframe", "list"),
  python_path = NULL
)
}
\arguments{
\item{data_dir}{Character. Directory containing the downloaded FindingEmo data.}

\item{output_format}{Character. Format for processed data: "dataframe" 
returns R data.frame, "list" returns full processed data (default: "dataframe").}

\item{python_path}{Character. Path to Python executable (optional).}
}
\value{
If \code{output_format = "dataframe"}: A data.frame with columns:
\itemize{
  \item \code{image_id}: Unique image identifier
  \item \code{valence}: Valence score (emotion positivity)
  \item \code{arousal}: Arousal score (emotion intensity)
  \item Additional columns as present in the dataset
}

If \code{output_format = "list"}: A list containing:
\itemize{
  \item \code{annotations}: Data.frame with annotation data
  \item \code{urls}: List with image URL information
  \item \code{metadata}: List with dataset metadata
}
}
\description{
Loads and preprocesses annotations from a downloaded FindingEmo-Light dataset.
Returns a clean R data.frame with emotion annotations, valence/arousal scores,
and associated metadata.
}
\details{
This function loads the CSV annotation file and JSON URLs file from a 
downloaded FindingEmo dataset, performs basic validation and preprocessing,
and returns the data in a format suitable for emotion analysis.

The function handles missing values, validates valence/arousal ranges,
and provides summary statistics for the loaded data.
}
\examples{
\dontrun{
# Download dataset first
download_result <- download_findingemo_data("./findingemo_data")

if (download_result$success) {
  # Load annotations as data.frame
  annotations <- load_findingemo_annotations("./findingemo_data")
  
  # Examine the data
  head(annotations)
  summary(annotations)
  
  # Get full processed data including metadata
  full_data <- load_findingemo_annotations(
    data_dir = "./findingemo_data",
    output_format = "list"
  )
  
  print(full_data$metadata)
}
}

}
\seealso{
\code{\link{download_findingemo_data}}, \code{\link{prepare_findingemo_evaluation}}
}
