% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.bayes}
\alias{train.bayes}
\title{train.bayes}
\usage{
train.bayes(formula, data, laplace = 0, ..., subset, na.action = na.pass)
}
\arguments{
\item{formula}{A formula of the form class ~ x1 + x2 + .... Interactions are not allowed.}

\item{data}{Either a data frame of predictors (categorical and/or numeric) or a contingency table.}

\item{laplace}{positive double controlling Laplace smoothing. The default (0) disables Laplace smoothing.}

\item{...}{Currently not used.}

\item{subset}{For data given in a data frame, an index vector specifying the cases to be used in the training sample. (NOTE: If given, this argument must be named.)}

\item{na.action}{A function to specify the action to be taken if NAs are found. The default action is not to count them for the computation of the probability factors. An alternative is na.omit, which leads to rejection of cases with missing values on any required variable. (NOTE: If given, this argument must be named.)}
}
\value{
A object bayes.prmdt with additional information to the model that allows to homogenize the results.
}
\description{
Provides a wrapping function for the \code{\link[e1071]{naiveBayes}}.
}
\note{
the parameter information was taken from the original function  \code{\link[e1071]{naiveBayes}}.
}
\examples{

# Classification
data("iris")

n <- seq_len(nrow(iris))
.sample <- sample(n, length(n) * 0.75)
data.train <- iris[.sample,]
data.test <- iris[-.sample,]

modelo.bayes <- train.bayes(Species ~., data.train)
modelo.bayes
prob <- predict(modelo.bayes, data.test, type = "prob")
prob
prediccion <- predict(modelo.bayes, data.test, type = "class")
prediccion

# Regression
len <- nrow(swiss)
sampl <- sample(x = 1:len,size = len*0.20,replace = FALSE)
ttesting <- swiss[sampl,]
ttraining <- swiss[-sampl,]
model.bayes <- train.bayes(Infant.Mortality~.,ttraining)
prediction <- predict(model.bayes, ttesting)
prediction

}
\seealso{
The internal function is from package \code{\link[e1071]{naiveBayes}}.
}
