% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-traffic.R
\name{prep_travel_time}
\alias{prep_travel_time}
\title{Prepare travel time outcome for Gaussian modeling}
\usage{
prep_travel_time(
  travel_time,
  distance = NULL,
  per_distance = FALSE,
  transform = c("log", "identity"),
  eps = 1e-06
)
}
\arguments{
\item{travel_time}{numeric vector (e.g., seconds).}

\item{distance}{optional numeric vector of same length (e.g., meters).}

\item{per_distance}{logical; if TRUE and distance provided, model travel_time / distance.}

\item{transform}{character; currently supports "log" or "identity".}

\item{eps}{small positive constant added before log to avoid log(0).}
}
\value{
list with y (transformed), meta (transform info).
}
\description{
Common choice is log(travel_time). If `distance` is provided, you can
optionally model time-per-distance.
}
\keyword{internal}
