% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit_car}
\alias{fit_car}
\title{Fit Gaussian CAR / ICAR regression via Gibbs sampling}
\usage{
fit_car(
  y,
  A,
  X = NULL,
  type = c("icar", "proper"),
  rho = 0.99,
  tau = 1,
  n_iter = 2000,
  burn_in = floor(n_iter/2),
  thin = 1,
  beta_init = NULL,
  x_init = NULL,
  sigma2_init = NULL,
  b0 = NULL,
  B0 = NULL,
  a0 = 2,
  b0_sigma = 1,
  center_icar = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{y}{Numeric response vector of length \code{n}.}

\item{A}{Square \code{n x n} adjacency/weight matrix (base matrix or \code{Matrix}).
Diagonal entries are ignored.}

\item{X}{Optional \code{n x p} design matrix. If \code{NULL}, no regression is fit.}

\item{type}{Either \code{"icar"} or \code{"proper"}.}

\item{rho}{Spatial dependence parameter for proper CAR. Ignored for ICAR.}

\item{tau}{Positive scalar precision multiplier.}

\item{n_iter}{Total MCMC iterations.}

\item{burn_in}{Number of initial iterations to discard.}

\item{thin}{Keep every \code{thin}-th draw after burn-in.}

\item{beta_init}{Optional initial \eqn{\beta} (length \code{p}).}

\item{x_init}{Optional initial latent field \eqn{x} (length \code{n}).}

\item{sigma2_init}{Optional initial \eqn{\sigma^2} (positive scalar).}

\item{b0}{Prior mean for \eqn{\beta} (length \code{p}). Default is zero vector.}

\item{B0}{Prior covariance for \eqn{\beta} (\code{p x p}). Default is large diagonal.}

\item{a0}{Shape parameter for inverse-gamma prior on \eqn{\sigma^2}.}

\item{b0_sigma}{Scale parameter for inverse-gamma prior on \eqn{\sigma^2}.}

\item{center_icar}{Logical; if \code{TRUE} and \code{type="icar"}, center \eqn{x}
to sum-to-zero within each connected component.}

\item{verbose}{Logical; print coarse progress updates.}
}
\value{
A list of class \code{"trafficCAR_fit"} with elements:
\describe{
  \item{\code{draws}}{List with MCMC draws \code{x}, \code{beta}, \code{sigma2}.}
  \item{\code{keep}}{Iteration indices that were saved.}
  \item{\code{type}, \code{rho}, \code{tau}}{Model hyperparameters used.}
}
y = X beta + x + epsilon
}
\description{
Fits a Gaussian regression with a CAR/ICAR latent effect:
\eqn{y = X\beta + x + \epsilon} with \eqn{\epsilon \sim N(0,\sigma^2 I)} and
\eqn{x \sim N(0, Q^{-1})}, where \eqn{Q = \tau (D - \rho A)} and
\eqn{D = diag(A 1)}. For ICAR, \eqn{\rho = 1}.
}
\details{
The sampler updates \eqn{x}, \eqn{\beta} (if \code{X} is provided), and \eqn{\sigma^2}
using Gibbs steps.
}
