% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning.R
\name{pruning_details}
\alias{pruning_details}
\alias{pruning_details.tna}
\alias{pruning_details.group_tna}
\title{Print Detailed Information on the Pruning Results}
\usage{
pruning_details(x, ...)

\method{pruning_details}{tna}(x, ...)

\method{pruning_details}{group_tna}(x, ...)
}
\arguments{
\item{x}{A \code{tna} or \code{group_tna} object.}

\item{...}{Ignored.}
}
\value{
A \code{data.frame} containing the removed edges if \code{x} is a \code{tna} object,
or a \code{list} of \code{data.frame} objects in the case of \code{group_tna} object.
}
\description{
Print Detailed Information on the Pruning Results
}
\examples{
model <- tna(group_regulation)
pruned_threshold <- prune(model, method = "threshold", threshold = 0.1)
pruning_details(pruned_threshold)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
