% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{sample_variable}
\alias{sample_variable}
\title{Sample from predictive distribution of a variable}
\usage{
sample_variable(
  object,
  newdata = NULL,
  variable_name = "mu_i",
  n_samples = 100,
  sample_fixed = TRUE,
  seed = 123456
)
}
\arguments{
\item{object}{output from \verb{\code{tinyVAST()}}}

\item{newdata}{data frame of new data, used to sample model components for predictions e.g., \code{mu_g}}

\item{variable_name}{name of variable available in report using \code{Obj$report()} or parameters using \code{Obj$env$parList()}}

\item{n_samples}{number of samples from the joint predictive distribution for fixed and random effects.  Default is 100, which is slow.}

\item{sample_fixed}{whether to sample fixed and random effects, \code{sample_fixed=TRUE} as by default, or just sample random effects, \code{sample_fixed=FALSE}}

\item{seed}{integer used to set random-number seed when sampling variables, as passed to \code{set.seed(.)}}
}
\value{
A matrix with a row for each \code{data} supplied during fitting, and
\code{n_samples} columns, where each column in a vector of samples
for a requested quantity given sampled uncertainty in fixed and/or random effects
}
\description{
\code{sample_variable} samples from the joint distribution of random (and optionally fixed) effects
to approximate the predictive distribution for a variable.
}
\details{
Using \code{sample_fixed=TRUE} (the default) in \code{\link{sample_variable}} propagates variance in both fixed and random effects, while
using \code{sample_fixed=FALSE} does not.
Sampling fixed effects will sometimes cause numerical under- or overflow (i.e., output values of \code{NA}) in cases when
variance parameters are estimated imprecisely.  In these cases, the multivariate normal approximation being used is a poor
representation of the tail probabilities, and results in some samples with implausibly high (or negative) variances,
such that the associated random effects then have implausibly high magnitude.
}
\examples{
 set.seed(101)
 x = runif(n = 100, min = 0, max = 2*pi)
 y = 1 + sin(x) + 0.1 * rnorm(100)

 # Do fit with getJointPrecision=TRUE
 fit = tinyVAST( formula = y ~ s(x),
                 data = data.frame(x=x,y=y) )

 # samples from distribution for the mean
 # excluding fixed effects due to CRAN checks
 samples = sample_variable(fit, sample_fixed = FALSE)

}
