% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{current-date-time}
\alias{current-date-time}
\alias{today}
\alias{now}
\title{Current Date and Time}
\usage{
today(tz = NULL)

now(tz = NULL, digits = 0)
}
\arguments{
\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}

\item{digits}{an integer value giving the number of decimal places for
seconds (0--6, 0 by default).}
}
\value{
\code{today} and \code{now} return an object of class \code{tind}
of length 1 and type \code{"d"} (date) and \code{"t"} (date-time),
respectively.
}
\description{
\code{today} returns the current date and \code{now} returns the current
date and time (in the system time zone or the time zone provided by the user).
}
\examples{
today()
now()
# millisecond accuracy
now(digits = 3)
# check current date and time in different time zones
if ("Asia/Tokyo" \%in\% OlsonNames()) {
now("Asia/Tokyo")
today("Asia/Tokyo")
}
if ("Europe/Warsaw" \%in\% OlsonNames()) {
now("Europe/Warsaw")
today("Europe/Warsaw")
}
if ("America/New_York" \%in\% OlsonNames()) {
now("America/New_York")
today("America/New_York")
}

}
