% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_caching.R
\name{tw_disconnect_from_cache}
\alias{tw_disconnect_from_cache}
\title{Ensure that connection to cache is disconnected consistently}
\usage{
tw_disconnect_from_cache(
  cache = NULL,
  cache_connection = NULL,
  disconnect_db = TRUE,
  language = tidywikidatar::tw_get_language()
)
}
\arguments{
\item{cache}{Defaults to NULL. If given, it should be given either \code{TRUE} or
FALSE. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is enabled,
\code{tidywikidatar} will use a local sqlite database. A custom connection to
other databases can be given (see vignette \code{caching} for details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see the
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{relevant
Wikimedia page}.}
}
\value{
Nothing, used for its side effects.
}
\description{
Ensure that connection to cache is disconnected consistently
}
\examples{
if (interactive()) {
  tw_get(
    id = c("Q180099"),
    language = "en"
  )
  tw_disconnect_from_cache()
}
}
