% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thermal_time.R
\name{interpolate_3hr}
\alias{interpolate_3hr}
\title{Interpolate 3-Hourly Temperature Values using sine curve.}
\usage{
interpolate_3hr(mint, maxt)
}
\arguments{
\item{mint}{A numeric vector of daily minimum temperatures.}

\item{maxt}{A numeric vector of daily maximum temperatures.}
}
\value{
A numeric matrix of interpolated 3-hourly temperature values. Rows correspond to input minimum and maximum temperatures and columns correspond to the eight interpolated 3-hourly intervals.
}
\description{
Interpolates temperature values at 3-hourly intervals from daily minimum
and maximum temperatures using a sine curve.
}
\examples{
mint <- c(0, 10)
maxt <- c(30, 40)
interpolate_3hr(mint = mint, maxt = maxt)

}
