% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_allele_sharing.R
\name{pairwise_allele_sharing}
\alias{pairwise_allele_sharing}
\title{Compute the Pairwise Allele Sharing Matrix for a \code{gen_tibble} object}
\usage{
pairwise_allele_sharing(
  x,
  as_matrix = FALSE,
  block_size = bigstatsr::block_size(nrow(x))
)
}
\arguments{
\item{x}{a \code{gen_tibble} object.}

\item{as_matrix}{boolean, determining whether the results should be a square
symmetrical matrix (TRUE), or a tidied tibble (FALSE, the default)}

\item{block_size}{maximum number of loci read at once. More loci should
improve speed, but will tax memory.}
}
\value{
a matrix of allele sharing between all pairs of individuals
}
\description{
This function computes the Allele Sharing matrix. Estimates Allele Sharing
(equivalent to the quantity estimated by \code{hierfstat::matching()}) between
pairs of individuals (for each locus, gives 1 if the two individuals are
homozygous for the same allele, 0 if they are homozygous for a different
allele, and 1/2 if at least one individual is heterozygous. Matching is the
average of these 0, 1/2 and 1s)
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Compute allele sharing between individuals
example_gt \%>\% pairwise_allele_sharing(as_matrix = FALSE)

# Alternatively, return as a tibble
example_gt \%>\% pairwise_allele_sharing(as_matrix = TRUE)
}
\seealso{
\code{\link[hierfstat:matching]{hierfstat::matching()}}
}
