% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervised-xgboost.R
\name{tl_fit_xgboost}
\alias{tl_fit_xgboost}
\title{Fit an XGBoost model}
\usage{
tl_fit_xgboost(
  data,
  formula,
  is_classification = FALSE,
  nrounds = 100,
  max_depth = 6,
  eta = 0.3,
  subsample = 1,
  colsample_bytree = 1,
  min_child_weight = 1,
  gamma = 0,
  alpha = 0,
  lambda = 1,
  early_stopping_rounds = NULL,
  nthread = NULL,
  verbose = 0,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{is_classification}{Logical indicating if this is a classification problem}

\item{nrounds}{Number of boosting rounds (default: 100)}

\item{max_depth}{Maximum depth of trees (default: 6)}

\item{eta}{Learning rate (default: 0.3)}

\item{subsample}{Subsample ratio of observations (default: 1)}

\item{colsample_bytree}{Subsample ratio of columns (default: 1)}

\item{min_child_weight}{Minimum sum of instance weight needed in a child (default: 1)}

\item{gamma}{Minimum loss reduction to make a further partition (default: 0)}

\item{alpha}{L1 regularization term (default: 0)}

\item{lambda}{L2 regularization term (default: 1)}

\item{early_stopping_rounds}{Early stopping rounds (default: NULL)}

\item{nthread}{Number of threads (default: max available)}

\item{verbose}{Verbose output (default: 0)}

\item{...}{Additional arguments to pass to xgb.train()}
}
\value{
A fitted XGBoost model
}
\description{
Fit an XGBoost model
}
\keyword{internal}
