% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionalInput.R
\name{optionalSliderInput}
\alias{optionalSliderInput}
\title{Optional Slider Input Widget}
\usage{
optionalSliderInput(inputId, label, min, max, value, label_help = NULL, ...)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{min, max}{The minimum and maximum values (inclusive) that can be
selected.}

\item{value}{The initial value of the slider, either a number, a date
(class Date), or a date-time (class POSIXt). A length one vector will
create a regular slider; a length two vector will create a double-ended
range slider. Must lie between \code{min} and \code{max}.}

\item{label_help}{(\code{shiny.tag}) optional\cr
object of class \code{shiny.tag}, e.g. an object returned by \code{\link[shiny:helpText]{shiny::helpText()}}}

\item{...}{optional arguments to \code{sliderInput}}
}
\value{
(\code{shiny.tag}) HTML tag with \code{sliderInput} widget.
}
\description{
Hidden input widgets are useful to have the \code{input[[inputId]]} variable
on available in the server function but no corresponding visual clutter from
input widgets that provide only a single choice.
}
\details{
if min or max are \code{NA} then the slider widget will be hidden
}
\examples{
ui <- bslib::page_fluid(
  shinyjs::useShinyjs(),
  optionalSliderInput("s", "shown", 0, 1, 0.2),
  optionalSliderInput("h", "hidden", 0, NA, 1),
)
if (interactive()) {
  shiny::shinyApp(ui, function(input, output) {})
}
}
