% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{sd_get_url_pars}
\alias{sd_get_url_pars}
\title{Get URL Parameters in a 'shiny' Application}
\usage{
sd_get_url_pars(...)
}
\arguments{
\item{...}{Optional. Names of specific URL parameters to retrieve.
If none are specified, all URL parameters are returned.}
}
\value{
A reactive expression that returns a list of URL parameters.
}
\description{
This function retrieves URL parameters from the current 'shiny' session.
It must be called from within a 'shiny' reactive context.
}
\examples{
if (interactive()) {
  library(surveydown)

  # Use sd_get_url_pars() to parse URL parameters:
  # server <- function(input, output, session) {
  #   # Get all URL parameters
  #   all_params <- sd_get_url_pars()
  #
  #   # Get specific parameters
  #   user_id <- sd_get_url_pars("user_id")
  #
  #   # Use in reactive expressions
  #   url_redirect <- reactive({
  #     params <- sd_get_url_pars()
  #     paste0("https://example.com?id=", params["id"])
  #   })
  #   sd_server()
  # }

  # Find a working directory and start from a template:
  sd_create_survey(template = "external_redirect")
  # This creates survey.qmd and app.R - launch the survey using app.R
}

}
