\name{as.cuneiform}
\alias{as.cuneiform}
\alias{as.cuneiform.default}
\alias{as.cuneiform.character}
\alias{print.cuneiform}

\title{Convert Transliterated Sumerian Text to Cuneiform}
\description{
Converts transliterated Sumerian text to Unicode cuneiform characters. This is a generic function with a method for character vectors.
}
\usage{
as.cuneiform(x, ...)

\method{as.cuneiform}{default}(x, ...)

\method{as.cuneiform}{character}(x, mapping = NULL, ...)

\method{print}{cuneiform}(x, ...)
}
\arguments{
  \item{x}{
    For \code{as.cuneiform}: An object to be converted to cuneiform. Currently, only character vectors are supported.

    For \code{print.cuneiform}: an object of class \code{"cuneiform"}.
  }
  \item{mapping}{A data frame containing the sign mapping table with columns \code{syllables}, \code{name}, and \code{cuneiform}. If \code{NULL} (the default), the package's internal mapping file \file{etcsl_mapping.txt} is loaded. Only used by the character method.}
  \item{...}{Additional arguments passed to methods.}
}
\details{
The function processes each element of the input character vector by:
\enumerate{
  \item Calling \code{\link{info}} to look up sign information for each transliterated sign.
  \item Extracting the Unicode cuneiform symbols for each sign.
  \item Reconstructing the cuneiform text using the original separators, but removing hyphens and periods which are only used in transliteration to indicate sign boundaries.
}

The default method throws an error for unsupported input types.
}
\value{
  \code{as.cuneiform} returns a character vector of class \code{cuneiform} with the cuneiform representation of each input element.

  \code{print.cuneiform} displays a character vector of class \code{cuneiform}.
}
\note{
The cuneiform output requires a font that supports the Unicode Cuneiform block (U+12000 to U+12500) to display correctly.
}
\seealso{
\code{\link{info}} for retrieving detailed sign information,
\code{\link{split_sumerian}} for splitting Sumerian text into signs,
\code{\link{as.sign_name}} for converting transliterated Sumerian text intos sign names
}
\examples{

# Convert transliterated text to cuneiform
as.cuneiform(c("na-an-jic li-ic ma","en tarah-an-na-ke4"))

# Load transliterated text from a file
file <- system.file("extdata", "transliterated-text.txt", package = "sumer")
x <- readLines(file)
cat(x, sep="\n")

# Convert transliterated text to cuneiform
as.cuneiform(x)

# Using a custom mapping table
path <- system.file("extdata", "etcsl_mapping.txt", package = "sumer")
my_mapping <- read.csv2(path, sep=";", na.strings="")
as.cuneiform("lugal", mapping = my_mapping)

}
\keyword{utilities}
\keyword{character}
\keyword{methods}
