% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_plot}
\alias{validate_plot}
\title{Validate Inputs for Plotting Functions}
\usage{
validate_plot(
  y,
  group = NULL,
  data = NULL,
  func_name = "plot",
  require_group = TRUE,
  data_name = NULL
)
}
\arguments{
\item{y}{A numeric vector, column name, or formula of the form y ~ group.}

\item{group}{A vector used to group the data, or a column name if data is provided.
Can be NULL for functions where group is optional.}

\item{data}{An optional data frame containing the variables.}

\item{func_name}{Character string. Name of the calling function (for error messages).}

\item{require_group}{Logical. If TRUE, group is required. If FALSE, group can be NULL.}

\item{data_name}{Character string. Name of the data argument (for error messages). 
If NULL, will attempt to infer from the call.}
}
\value{
A list containing:
\itemize{
  \item \code{y}: Validated y variable (numeric vector)
  \item \code{group}: Validated group variable (if provided, otherwise NULL)
  \item \code{y_name}: Clean variable name for y (for labels)
  \item \code{group_name}: Clean variable name for group (for labels)
  \item \code{y_name_raw}: Raw variable name for y (for error messages)
  \item \code{group_name_raw}: Raw variable name for group (for error messages)
  \item \code{data_name}: Name of data argument (for error messages)
}
}
\description{
Validates inputs for plotting functions that accept either formula syntax
(y ~ group) or standard syntax (y, group), with optional data frame.
}
\keyword{internal}
