% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_sql.R
\name{convert_to_sql}
\alias{convert_to_sql}
\title{Convert CSV file to SQL INSERT statements}
\usage{
convert_to_sql(input, output, create_table = FALSE)
}
\arguments{
\item{input}{Character string. Path to the input CSV file.}

\item{output}{Character string. Path to the output SQL file where the
statements will be written.}

\item{create_table}{Logical. If \code{TRUE}, includes a CREATE TABLE
statement before the INSERT statements. Default is \code{FALSE}.}
}
\value{
Invisibly returns NULL. The function writes SQL statements to the
  specified output file.
}
\description{
Reads a CSV file and generates SQL statements to insert all rows. Optionally
can also generate a CREATE TABLE statement. The function automatically infers
column types (REAL for numeric, DATE for date strings matching YYYY-MM-DD
format, TEXT otherwise).
}
\details{
The function performs the following steps:
\enumerate{
  \item Reads the CSV file using \code{read.csv()} with
    \code{stringsAsFactors = FALSE}
  \item Infers SQL column types:
    \itemize{
      \item Numeric columns become \code{REAL}
      \item Date columns (matching YYYY-MM-DD format) become \code{DATE}
      \item All other columns become \code{TEXT}
    }
  \item If \code{create_table = TRUE}, generates a \code{CREATE TABLE}
    statement using the base filename (without extension) as the table name
  \item Generates \code{INSERT INTO} statements for each row
  \item Writes all SQL statements to the output file
}

Single quotes in text values are escaped by doubling them (SQL standard).
Numeric values are inserted without quotes, while text and date values are
wrapped in single quotes.
}
\examples{
# Convert a CSV file to SQL (INSERT statements only)
tmp_csv <- tempfile(fileext = ".csv")
tmp_sql <- tempfile(fileext = ".sql")
write.csv(
  data.frame(id = 1:2, value = c("a", "b"), date = c("2024-01-01", "2024-02-02")),
  tmp_csv,
  row.names = FALSE
)
convert_to_sql(tmp_csv, tmp_sql)

# Convert a CSV file to SQL with CREATE TABLE statement
convert_to_sql(tmp_csv, tmp_sql, create_table = TRUE)

}
