% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.mean.prior}
\alias{size.ci.mean.prior}
\title{Sample size for a mean confidence interval using an estimated variance from
a prior study}
\usage{
size.ci.mean.prior(alpha1, alpha2, var0, n0, w)
}
\arguments{
\item{alpha1}{alpha level for 1-alpha1 confidence in the planned study}

\item{alpha2}{alpha level for the 1-alpha2 prediction interval}

\item{var0}{estimated variance in prior study}

\item{n0}{sample size in prior study}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a population mean with
desired confidence interval precision in applications where an estimated
variance from a prior study is available. The actual confidence interval
width in the planned study will depend on the value of the estimated
variance in the planned study. An estimated variance from a prior study
can be used to compute an upper prediction limit for the estimated variance
in the planned study. The upper prediction limit is then used as the variance
planning value.  The probability that the prediction interval in the planned
study will have a width that is less than the desired width is approximately
1 - alpha2.

This sample size approach assumes that the population variance in the
prior study is very similar to the population variance in the planned
study. If an estimated variance from a prior study is not available,
the researcher must use expert opinion to guess the value of the variance
that will be observed in the planned study. The \link[statpsych]{size.ci.mean}
function uses a variance planning value that is based on expert opinion
regarding the likely value of the variance estimate that will be observed
in the planned study.

For more details, see Section 1.31 of Bonett (2021, Volume 1)
}
\examples{
size.ci.mean.prior(.05, .10, 0.71, 204, .4)

# Should return:
# Sample size
#          88

}
\references{
\insertRef{Bonett2021}{statpsych}
}
