% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_states_chart.R
\name{panel_st_agg_node}
\alias{panel_st_agg_node}
\title{Create a space-time visualization with node aggregation.}
\usage{
panel_st_agg_node(
  data,
  x_start = data$config$limits$start,
  x_end = data$config$limits$end,
  step = data$config$st$aggregation$step,
  legend = data$config$st$legend,
  selected_nodes = data$config$selected_nodes
)
}
\arguments{
\item{data}{starvz_data with trace data}

\item{x_start}{X-axis start value}

\item{x_end}{X-axis end value}

\item{step}{time-step}

\item{legend}{option to activate legend}

\item{selected_nodes}{select only some nodes in some plots}
}
\value{
A ggplot object
}
\description{
Use any state trace data to plot the task computations by Node
over the execution time with Gantt Chart. This function aggregate
states within the same resource type.
}
\examples{
\donttest{
panel_st_agg_node(data = starvz_sample_lu)
}
}
