% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline.R
\name{time_spline_basis}
\alias{time_spline_basis}
\title{Natural Cubic Spline Basis Matrix for Continuous Time.}
\usage{
time_spline_basis(time, df, Boundary.knots = c(0, max(time)), ...)
}
\arguments{
\item{time}{Continuous time variable, passed directly to \code{\link[splines:ns]{splines::ns()}} as
the first argument.}

\item{df}{Degrees of freedom, passed directly to the \code{df} argument of
\code{\link[splines:ns]{splines::ns()}}.}

\item{Boundary.knots}{Boundary knots, passed directly to the \code{Boundary.knots}
argument of \code{\link[splines:ns]{splines::ns()}}. Defaults to \code{c(0, max(time))}.}

\item{...}{Passed to \code{\link[splines:ns]{splines::ns()}}.}
}
\value{
A matrix of dimension \code{length(time) * df}. See the \emph{Value} section
of \code{\link[splines:ns]{splines::ns()}}.
}
\description{
Wrapper around \code{\link[splines:ns]{splines::ns()}} with default \code{Boundary.knots} of \code{c(0, max(time))}.
}
\details{
\code{time_spline()} is primarily useful because it can create the spline basis
from \code{time} and then re-input \code{time} into the spline basis to obtain the
predictions in one step. Or, it can calculate predictions from a basis
supplied to the \code{basis} argument.
}
\examples{
time_spline_basis(Theoph$Time, df = 3)
}
