% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables_ascii.R
\name{spicy_print_table}
\alias{spicy_print_table}
\title{Print a spicy-formatted ASCII table}
\usage{
spicy_print_table(
  x,
  title = attr(x, "title"),
  note = attr(x, "note"),
  padding = c("compact", "normal", "wide"),
  first_column_line = TRUE,
  row_total_line = TRUE,
  column_total_line = TRUE,
  bottom_line = FALSE,
  lines_color = "darkgrey",
  align_left_cols = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{spicy_table} or \code{data.frame} to be printed.}

\item{title}{Optional title displayed above the table. Defaults to the
\code{"title"} attribute of \code{x} if present.}

\item{note}{Optional note displayed below the table. Defaults to the \code{"note"}
attribute of \code{x} if present.}

\item{padding}{Character string controlling horizontal spacing between columns:
\itemize{
\item \code{"compact"} — minimal spacing
\item \code{"normal"} — moderate spacing (default)
\item \code{"wide"} — extra spacing (for wide displays)
}}

\item{first_column_line}{Logical; if \code{TRUE} (default), adds a vertical separator
after the first column.}

\item{row_total_line, column_total_line, bottom_line}{Logical flags controlling
the presence of horizontal lines before total rows/columns or at the bottom
of the table.
Defaults are \code{TRUE} for \code{row_total_line} and \code{column_total_line}, and \code{FALSE}
for \code{bottom_line}.}

\item{lines_color}{Character; color for table separators (default: \code{"darkgrey"}).
Only applied if the output supports ANSI colors (see \code{\link[crayon:has_color]{crayon::has_color()}}).}

\item{align_left_cols}{Integer vector of column indices to left-align.
If \code{NULL} (default), alignment is auto-detected based on \code{x}:
\itemize{
\item For \code{freq} tables → \code{c(1, 2)}
\item For \code{cross} tables → \code{1}
}}

\item{...}{Additional arguments passed to \code{\link[=build_ascii_table]{build_ascii_table()}}.}
}
\value{
Invisibly returns \code{x}, after printing the formatted ASCII table to the console.
}
\description{
User-facing helper that prints a visually aligned, spicy-styled ASCII table
created by functions such as \code{\link[=freq]{freq()}} or cross_table().
It automatically adjusts column alignment, spacing, and separators for
improved readability in console outputs.

This function wraps the internal renderer \code{\link[=build_ascii_table]{build_ascii_table()}}, adding
optional titles, notes, and automatic alignment rules depending on the type
of table.
}
\details{
\code{spicy_print_table()} detects whether the table represents frequencies
(\code{freq}-style) or cross-tabulations (\code{cross}-style) and adjusts formatting
accordingly:
\itemize{
\item For \strong{frequency tables}, the first two columns (\emph{Category} and \emph{Values})
are left-aligned.
\item For \strong{cross tables}, only the first column (row variable) is left-aligned.
}

The function supports Unicode line-drawing characters and colored separators
using the \strong{crayon} package, with graceful fallback to monochrome output when
color is not supported.
}
\examples{
# Simple demonstration
df <- data.frame(
  Category = c("Valid", "", "Missing", "Total"),
  Values = c("Yes", "No", "NA", ""),
  Freq. = c(12, 8, 1, 21),
  Percent = c(57.1, 38.1, 4.8, 100.0)
)

spicy_print_table(df,
  title = "Frequency table: Example",
  note = "Class: data.frame\nData: demo"
)

}
\seealso{
\code{\link[=build_ascii_table]{build_ascii_table()}} for the underlying text rendering engine.
\code{\link[=print.spicy_freq_table]{print.spicy_freq_table()}} for the specialized printing method used by \code{\link[=freq]{freq()}}.
}
