% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simCRdata.R
\name{simCRdata}
\alias{simCRdata}
\title{Simulate Competing Risks Data}
\usage{
simCRdata(N, beta = NULL, eta = rep(0.1, 3), nu = rep(1.1, 3), cens = 1, ...)
}
\arguments{
\item{N}{Integer. Number of individuals to simulate.}

\item{beta}{Numeric matrix of dimension 2x3. Covariate effects of \code{L0} and \code{A0} on the three competing processes (columns correspond to processes). Defaults to zero matrix if \code{NULL}.}

\item{eta}{Numeric vector of length 3. Shape parameters for Weibull hazards, parameterized as \eqn{\eta \nu t^{\nu - 1}}. Defaults to \code{rep(0.1, 3)}.}

\item{nu}{Numeric vector of length 3. Scale parameters for Weibull hazards. Defaults to \code{rep(1.1, 3)}.}

\item{cens}{Binary (0 or 1). Indicates if a censoring process is included. Default is 1.}

\item{...}{Additional arguments passed to \code{\link{simEventData}}, including \code{add_cov} for extra covariates.}
}
\value{
A \code{data.frame} with simulated competing risk data including:
\itemize{
\item \code{ID} - Individual identifier.
\item \code{Time} - Event time.
\item \code{Delta} - Event type (0, 1, or 2).
\item \code{L0} - Baseline covariate.
\item \code{A0} - Baseline treatment indicator.
}
}
\description{
Simulates competing risks data for \eqn{N} individuals who are at risk of mutually exclusive event types.
Three event types are simulated, where one can be interpreted as censoring.
}
\details{
The event intensities follow Weibull hazard models parameterized by shape and scale parameters \eqn{\eta} and \eqn{\nu}.
Covariate effects on the hazard are specified by the \code{beta} matrix, which models the effects of baseline covariates \code{L0} and \code{A0} on each event type.
}
\examples{
simCRdata(10)
}
