% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetric_and_causal_Shapley.R
\name{check_categorical_valid_MCsamp}
\alias{check_categorical_valid_MCsamp}
\title{Check that all explicands has at least one valid MC sample in causal Shapley values}
\usage{
check_categorical_valid_MCsamp(dt, n_explain, n_MC_samples, joint_prob_dt)
}
\arguments{
\item{dt}{Data.table containing the generated MC samples (and conditional values) after each sampling step}

\item{n_MC_samples}{Positive integer.
For most approaches, it indicates the maximum number of samples to use in the Monte Carlo integration
of every conditional expectation.
For \code{approach="ctree"}, \code{n_MC_samples} corresponds to the number of samples
from the leaf node (see an exception related to the \code{ctree.sample} argument in \code{\link[=setup_approach.ctree]{setup_approach.ctree()}}).
For \code{approach="empirical"}, \code{n_MC_samples} is the \eqn{K} parameter in equations (14-15) of
\href{https://martinjullum.com/publication/aas-2021-explaining/aas-2021-explaining.pdf}{Aas et al. (2021)},
i.e. the maximum number of observations (with largest weights) that is used, see also the
\code{empirical.eta} argument \code{\link[=setup_approach.empirical]{setup_approach.empirical()}}.}
}
\description{
Check that all explicands has at least one valid MC sample in causal Shapley values
}
\details{
For undocumented arguments, see \code{\link[=setup_approach.categorical]{setup_approach.categorical()}}.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
