% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_filter_helpers.R
\name{st_extract_filter_id}
\alias{st_extract_filter_id}
\title{Extract Filter ID from Sensor Tower URL}
\usage{
st_extract_filter_id(url)
}
\arguments{
\item{url}{Character string. A Sensor Tower URL containing custom_fields_filter_id}
}
\value{
Character string. The extracted filter ID, or NULL if not found.
}
\description{
Extracts the custom_fields_filter_id parameter from a Sensor Tower URL.
This is helpful when copying URLs from the web interface.
}
\examples{
\dontrun{
url <- "https://app.sensortower.com/top-charts?custom_fields_filter_id=687df26ac5a19ebcfe817d7f"
filter_id <- st_extract_filter_id(url)
}
}
