% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{jsondec}
\alias{jsondec}
\title{JSON Decode}
\usage{
jsondec(x)
}
\arguments{
\item{x}{Character string or raw vector containing JSON data.}
}
\value{
The corresponding R object, or an empty list for invalid input.
}
\description{
Minimal JSON parser. Converts JSON to R objects with proper type handling.
}
\details{
This is a minimal implementation designed for parsing HTTP API responses.
}
\section{Type Mappings}{

\itemize{
\item Object \code{{}} -> named list
\item Array \verb{[]} -> unnamed list
\item String -> character
\item Number -> numeric
\item \code{true}/\code{false} -> logical
\item \code{null} -> \code{NULL}
}
}

\section{RFC 8259 Non-conformance}{

\itemize{
\item Invalid JSON returns an empty list instead of erroring.
\item Duplicate keys are preserved; R accessors (\code{$}, \code{[[}) return first
match.
\item Non-standard number forms may be accepted (e.g., leading zeros,
hexadecimal).
\item Invalid escape sequences are output literally (e.g., \verb{\\\\uZZZZ}
becomes \code{"uZZZZ"}).
\item Incomplete Unicode escape sequences for emoji are tolerated.
\item Nesting depth is limited to 512 levels.
}
}

\examples{
jsondec('{"name": "John", "age": 30}')
jsondec('[1, 2, 3]')
jsondec('"a string"')
jsondec('123')
jsondec('true')

}
\seealso{
\code{\link[=jsonenc]{jsonenc()}}
}
