% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_category_svc}
\alias{make_category_svc}
\title{Set up spatially varying coefficients for category composition models}
\usage{
make_category_svc(
  data,
  category_column,
  time_column,
  share_spatial_sd = TRUE,
  share_spatiotemporal_sd = TRUE
)
}
\arguments{
\item{data}{Data frame containing the composition data.}

\item{category_column}{Character. Name of the category column (e.g., "Age",
"length_bin", "species").}

\item{time_column}{Character. Name of the time column (e.g., "Year").}

\item{share_spatial_sd}{Logical. If \code{TRUE}, all categories share the same
spatial SD. If \code{FALSE}, each category gets its own spatial SD.}

\item{share_spatiotemporal_sd}{Logical. If \code{TRUE}, all category-time
combinations share the same spatiotemporal SD. If \code{FALSE}, each gets its
own.}
}
\value{
A list containing:
\itemize{
\item \code{data_expanded}: Data frame with added model matrix columns for use in \code{\link[=sdmTMB]{sdmTMB()}}.
\item \code{svc_formula}: Formula for the \code{spatial_varying} argument in \code{\link[=sdmTMB]{sdmTMB()}}.
\item \code{svc_map}: Map list for the \code{map} argument in \code{\link[=sdmTMBcontrol]{sdmTMBcontrol()}}.
\item \code{info}: List with summary information about the model structure.
}
}
\description{
This function helps set up the data structure, formula, and mapping needed
for fitting spatially varying coefficient models with categories (e.g., ages,
length bins, species) that have both spatial and spatiotemporal random
fields. It's particularly useful for age or length composition
standardization models.
}
\details{
This function creates spatially varying coefficient structures for
composition models by setting up:
\enumerate{
\item \strong{Spatial fields}: One field per category (e.g., age-specific spatial
fields) 2. \strong{Spatiotemporal fields}: One field per category-time combination
(e.g., age-year fields)
}

The sharing of variance parameters is controlled by \code{share_spatial_sd} and
\code{share_spatiotemporal_sd}. When \code{TRUE}, all fields of that type share the
same variance parameter, which is more parsimonious but assumes similar
variance magnitudes across categories.

The resulting model structure allows each category to have its own spatial
pattern and temporal variation while controlling parameter sharing for
identifiability and computational efficiency.
}
\examples{
set.seed(123)
data <- data.frame(
  age = factor(rep(1:3, each = 20)),
  year = rep(2020:2022, 20),
  abundance = rnorm(60),
  x = runif(60), y = runif(60)
)

# Set up model components
setup <- make_category_svc(
  data = data,
  category_column = "age",
  time_column = "year",
  share_spatial_sd = TRUE,
  share_spatiotemporal_sd = TRUE
)

# Check the setup
setup$info

# See the age composition standardization vignette for more details
}
