% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{draws_sd}
\alias{draws_sd}
\alias{draws_sd.rvec_chr}
\alias{draws_sd.rvec}
\alias{draws_var}
\alias{draws_var.rvec_chr}
\alias{draws_var.rvec}
\alias{draws_cv}
\alias{draws_cv.rvec_chr}
\alias{draws_cv.rvec}
\title{Standard Deviations, Variances, and Coefficients
of Variation Across Random Draws}
\usage{
draws_sd(x, na_rm = FALSE)

\method{draws_sd}{rvec_chr}(x, na_rm = FALSE)

\method{draws_sd}{rvec}(x, na_rm = FALSE)

draws_var(x, na_rm = FALSE)

\method{draws_var}{rvec_chr}(x, na_rm = FALSE)

\method{draws_var}{rvec}(x, na_rm = FALSE)

draws_cv(x, na_rm = FALSE)

\method{draws_cv}{rvec_chr}(x, na_rm = FALSE)

\method{draws_cv}{rvec}(x, na_rm = FALSE)
}
\arguments{
\item{x}{An object of class \link[=rvec]{rvec}.}

\item{na_rm}{Whether to remove NAs before
calculating summaries. Default is \code{FALSE}.}
}
\value{
A vector.
}
\description{
Use standard deviations, variances, or
coefficients of variation to
summarise the distribution of random draws
in an rvec.
}
\details{
The coefficient of variation is the standard
deviation divided by the mean.
}
\examples{
m <- rbind(a = c(1, 1, 1, 2, 3),
           b = c(2, 4, 0, 2, 3),
           c = c(0, 0, 1, 0, 100))
x <- rvec(m)
x
draws_sd(x)
draws_var(x)
draws_cv(x)
}
\seealso{
Apply pre-specified functions across draws:
\itemize{
\item \code{\link[=draws_all]{draws_all()}}
\item \code{\link[=draws_any]{draws_any()}}
\item \code{\link[=draws_mean]{draws_mean()}}
\item \code{\link[=draws_median]{draws_median()}}
\item \code{\link[=draws_mode]{draws_mode()}}
\item \code{\link[=draws_min]{draws_min()}}
\item \code{\link[=draws_max]{draws_max()}}
\item \code{\link[=draws_ci]{draws_ci()}}
\item \code{\link[=draws_quantile]{draws_quantile()}}
}

Apply arbitrary function across draws:
\itemize{
\item \code{\link[=draws_fun]{draws_fun()}}
}
}
