% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survstat-loader.R
\name{get_snapshot}
\alias{get_snapshot}
\title{Retrieve data from the \code{SurvStat} web service relating to a single time period.}
\usage{
get_snapshot(
  disease = NULL,
  measure = c("Count", "Incidence"),
  ...,
  season,
  season_week = NULL,
  season_start = 1,
  age_group = NULL,
  age_range = c(0, Inf),
  disease_subtype = FALSE,
  geography = NULL,
  .progress = TRUE
)
}
\arguments{
\item{disease}{the disease of interest as a \code{SurvStat} key, see
\code{rsurvstat::diseases} for a current list of these. This is technically
optional, and if omitted the counts of all diseases will be returned. Keys
are the same as the options in the \code{SurvStat} user interface found
\href{https://survstat.rki.de/Content/Query/Main.aspx#CreateQuery}{here}. \code{IfSG}
and \code{state} variants of diseases are counts that are reported directly to
the Robert Koch Institute or indirectly via state departments.}

\item{measure}{one of \code{"Count"} (default) or \code{"Incidence"} per 100,000 per
week or year depending on the context.}

\item{...}{not used, must be empty.}

\item{season}{the start year of the season in which the snapshot is taken}

\item{season_week}{the start week within the season of the snapshot. If missing
then the whole season is used}

\item{season_start}{the week of the calendar year in which the season starts
this can be one of \code{1}, \code{27} or \code{40}.}

\item{age_group}{(optional) the age group of interest as a \code{SurvStat} key,
see \code{rsurvstat::age_groups} for a list of valid options.}

\item{age_range}{(optional) a length 2 vector with the minimum and maximum
ages to consider}

\item{disease_subtype}{if \code{TRUE} the returned count will be broken down by
disease or pathogen subtype (assuming \code{disease} was provided).}

\item{geography}{(optional) a geographical breakdown. This can be given as a
character where it must be one of \code{state}, \code{nuts}, or \code{county} specifying
the 16 region \code{FedStateKey71Map}, 38 region \code{NutsKey71Map}, or 411 region
\code{CountyKey71Map} data respectively. Alternatively it can be given as a
as a \code{sf} dataframe, subsetting one of these maps, in which case only that
subset of regions will be returned.}

\item{.progress}{by default a progress bar is shown, which may be important
if many downloads are needed to fulfil the request. It can be disabled
by setting this to \code{FALSE} here.}
}
\value{
a data frame with at least \code{year} (the start of the epidemiological
season) and \code{start_week} (the calendar week in which the epidemiological
season starts), and one of \code{count} or \code{incidence} columns. Most likely it
will also have \code{disease_name} and \code{disease_code} columns, and some of
\code{age_name}, \code{age_code}, \code{age_low}, \code{age_high}, \code{geo_code}, \code{geo_name},
\code{disease_subtype_code}, \code{disease_subtype_name} depending on options.
}
\description{
This function gets a snapshot of disease count or incidence data
from the  Robert Koch Institute \code{SurvStat} web service, based on either whole
epidemiological season or an individual week within a season. Seasons are
whole years starting either at the beginning of the calendar year, at week 27
or at week 40.
}
\details{
The snapshot can be stratified by any combination of age, geography, disease,
disease subtype. Queries to \code{SurvStat} are cached and paged, but obviously
multidimensional extracts have the potential to need a lot of downloading.
}
\examples{
\donttest{
get_snapshot(
  diseases$`COVID-19`,
  measure = "Count",
  season = 2024,
  age_group = age_groups$children_coarse
)

get_snapshot(
  diseases$`COVID-19`,
  measure = "Count",
  age_group = age_groups$children_coarse,
  season = 2024,
  geography = rsurvstat::FedStateKey71Map[1:10,]
)
}
}
\concept{survstat}
