% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_publications.R
\name{road_get_publications}
\alias{road_get_publications}
\title{Get publication references from the ROAD database}
\usage{
road_get_publications(localities = NULL, bibtex = FALSE)
}
\arguments{
\item{localities}{specifies the subset of localities for which publications 
should be retrieved. This parameter can be a string (a single locality name), 
a vector of strings (multiple locality names), or a data frame containing a 
\code{locality_id} column (e.g., the output of \code{road_get_localities()}). 
Defaults to \code{NULL}.}

\item{bibtex}{specifies if publication references should be formatted as \code{BibTeX}.
Defaults to \code{FALSE}.}
}
\value{
A data frame with two columns:

\code{Locality}: Is only returned, if the argument \code{localities}
is populated.

\code{Publication}: Items from ROAD's publication table, formatted as
reference or \code{BibTex}.
}
\description{
The \strong{\code{road_get_publications}} function retrieves publication 
references from the ROAD database. Entries are available in the \code{BibTex}
format or formatted according to bibliographic conventions, including books,
journal articles, book chapters, theses, and web pages.
}
\details{
Use arguments to filter search results by location or output format, or omit
them to have a broader result set. All arguments are optional and should be
omitted or set to NULL when not used.

With \code{localities = NULL} (the default), the function produces a 
complete list of all references compiled in ROAD, with each publication 
appearing only once. When \code{localities} is specified, duplicates may occur 
in the \code{Publication} column, if a single source provides information for 
multiple sites.

All parameters are optional. If not used, omit them or set them to NULL.
}
\examples{
\donttest{road_get_publications(localities = c("Apollo 11", "Berg Aukas"))}

\donttest{# Using result from road_get_localities}
\donttest{locs <- road_get_localities(country = "Estonia")}
\donttest{road_get_publications(localities = locs)}
}
