% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_archaeology.R
\name{road_get_lithic_typologies}
\alias{road_get_lithic_typologies}
\title{Get lithic typology from the ROAD database}
\usage{
road_get_lithic_typologies(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL,
  assemblages = NULL,
  tool_list = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument \code{continent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe). 
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated 
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")} 
to display possible values.
The argument \code{country} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the 
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age 
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")} 
to display possible values. The argument \code{cultural_period} is a string 
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool 
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes 
human remains, raw material, typology, technology, function, organic tools, 
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains, 
plant remains. The argument \code{category} is a string (one item) or 
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to an integer; defaults to NULL.}

\item{assemblages}{specifies a data frame necessarily containing columns 
locality_id, assemblage_id. It can be  generated as return value of the 
function 'road_get_assemblages'. It can be used instead of the locality 
and assemblage search parameters to filter the results.}

\item{tool_list}{specifies values that can be entered for various tool types. 
Tool types can contain 1) chipped tool types like scraper end, scraper side, 
scraper, carinated, burin, handaxe, chopper, cleaver, point, point unifacial, 
segment, unknown; 2) non-chipped tool types like grindstone upper, hammerstone, 
anvil, retoucher; 3) non-tools like core, debitage, flake, point; 4) unknown 
like cobble, block, manuport. Run \code{road_list_argument_values("tool_list")} 
to display possible values. The argument \code{tool_list} is a string (one item) 
or vector of strings (one or more items); defaults to NULL.}
}
\value{
A data frame with information about lithic typology. Rows represent individual lithic finds, columns contain typology-related details on:

\code{typology}: Description of the tool type group present in the 
lithic record. Possible values are: "chipped tool", "non-chipped tool", "non-tool", 
and "unknown".

\code{percentage}:Percentage of the given typology within the corresponding assemblage.

\code{tool_list}: List of specific tool types present in the lithic record.
}
\description{
The \strong{\code{road_get_lithic_typologies}} function retrieves data on find typology 
from the ROAD database. Lithic typology refers to the classification of stone tools 
based on their shape, technology, and function. This function allows you to query 
lithic typology data using various parameters, such as geographical location, cultural 
period, tool type, and assemblage. Use these parameters to filter results according to 
your research needs, or omit them to retrieve a broader dataset.
}
\examples{
\donttest{road_get_lithic_typologies(country = c("South Africa"), tool_list = "adze")}
\donttest{road_get_lithic_typologies(subcontinent = "Eastern Europe", 
                         tool_list = c("bladelet burin spall"))}
}
