/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.sa.base.core.tests.SeasonalityTests;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.regsarima.regular.SeasonalityDetector;

public class TramoSeasonalityDetector
implements SeasonalityDetector {
    private SeasonalityTests tests;
    private int ost;

    public SeasonalityTests getTests() {
        return this.tests;
    }

    public SeasonalityDetector.Seasonality hasSeasonality(DoubleSeq y, int period) {
        this.ost = 0;
        if (period <= 1) {
            return SeasonalityDetector.Seasonality.NotApplicable;
        }
        this.tests = new SeasonalityTests();
        this.tests.test(y, period, 1, true);
        int ost95 = 0;
        int cqs = 0;
        int cnp = 0;
        StatisticalTest qs = this.tests.getQs();
        StatisticalTest np = this.tests.getNonParametricTest();
        if (qs.getPvalue() < 0.01) {
            cqs = 2;
            ++this.ost;
            ++ost95;
        } else if (qs.getPvalue() < 0.05) {
            cqs = 1;
            ++ost95;
        }
        if (np.getPvalue() < 0.01) {
            cnp = 2;
            ++this.ost;
            ++ost95;
        } else if (np.getPvalue() < 0.05) {
            cnp = 1;
            ++ost95;
        }
        if (cqs == 2) {
            return SeasonalityDetector.Seasonality.Strong;
        }
        if (ost95 == 2) {
            return SeasonalityDetector.Seasonality.Moderate;
        }
        if (this.ost == 1 || ost95 == 1) {
            return SeasonalityDetector.Seasonality.Weak;
        }
        return SeasonalityDetector.Seasonality.NotObservable;
    }
}

