/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import java.util.ArrayList;
import java.util.List;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaProcessor;
import jdplus.toolkit.base.core.regsarima.regular.SeasonalityDetector;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihood;
import jdplus.tramoseats.base.api.tramo.AutoModelSpec;
import jdplus.tramoseats.base.api.tramo.EasterSpec;
import jdplus.tramoseats.base.api.tramo.OutlierSpec;
import jdplus.tramoseats.base.api.tramo.RegressionTestType;
import jdplus.tramoseats.base.api.tramo.TradingDaysSpec;
import jdplus.tramoseats.base.api.tramo.TramoSpec;
import jdplus.tramoseats.base.api.tramo.TransformSpec;
import jdplus.tramoseats.base.core.tramo.AutomaticFRegressionTest;
import jdplus.tramoseats.base.core.tramo.AutomaticRegressionTest;
import jdplus.tramoseats.base.core.tramo.AutomaticWaldRegressionTest;
import jdplus.tramoseats.base.core.tramo.DefaultRegressionTest;
import jdplus.tramoseats.base.core.tramo.FastRegressionTest;
import jdplus.tramoseats.base.core.tramo.FinalEstimator;
import jdplus.tramoseats.base.core.tramo.LogLevelModule;
import jdplus.tramoseats.base.core.tramo.ModelBenchmarking;
import jdplus.tramoseats.base.core.tramo.ModelController;
import jdplus.tramoseats.base.core.tramo.ModelEstimator;
import jdplus.tramoseats.base.core.tramo.ModelStatistics;
import jdplus.tramoseats.base.core.tramo.RegularUnderDifferencingTest;
import jdplus.tramoseats.base.core.tramo.RegularUnderDifferencingTest2;
import jdplus.tramoseats.base.core.tramo.SeasonalUnderDifferencingTest;
import jdplus.tramoseats.base.core.tramo.SeasonalUnderDifferencingTest2;
import jdplus.tramoseats.base.core.tramo.SeasonalityController;
import jdplus.tramoseats.base.core.tramo.TradingDaysController;
import jdplus.tramoseats.base.core.tramo.TramoContext;
import jdplus.tramoseats.base.core.tramo.TramoModelBuilder;
import jdplus.tramoseats.base.core.tramo.TramoSeasonalityDetector;
import jdplus.tramoseats.base.core.tramo.internal.ArmaModule;
import jdplus.tramoseats.base.core.tramo.internal.DifferencingModule;
import jdplus.tramoseats.base.core.tramo.internal.OutliersDetectionModule;
import jdplus.tramoseats.base.core.tramo.internal.TramoUtility;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TramoKernel
implements RegSarimaProcessor {
    private static final String LAST_CHANCE = "last chance model";
    private static final String OUTLIERS_VA_REDUCED = "reduction of the critical value for outliers detection";
    private static final String AMI = "automatic model identification";
    private static final String ROUND = "round ";
    private static final String LOGNEG = "can't apply log transformation 'some obs. are <= 0";
    private static final String TRAMO = "tramo";
    private final TramoSpec spec;
    private final ModellingContext modellingContext;
    private final AmiOptions options;
    private final TramoContext context = new TramoContext();
    private final SeasonalityController scontroller;
    private final List<ModelController> controllers = new ArrayList<ModelController>();
    private RegSarimaModelling refAuto;
    private ModelStatistics refStats;
    private int pass = 0;
    private int round = 0;
    private double curva = 0.0;
    private double pcr = 0.0;
    private boolean pass3;
    private boolean needOutliers;
    private boolean needAutoModelling;
    private static final String SEAS = "seasonality test";
    private static final String NO_SEAS = "No identifiable seasonality";
    private static final String HAS_SEAS3 = "strong seasonality detected";
    private static final String HAS_SEAS2 = "moderate seasonality detected";

    public static TramoKernel of(TramoSpec spec, ModellingContext context) {
        return new TramoKernel(spec, context);
    }

    private TramoKernel(TramoSpec spec, ModellingContext context) {
        this.spec = spec;
        this.modellingContext = context;
        this.options = TramoKernel.readAmiOptions(spec);
        TradingDaysSpec td = spec.getRegression().getCalendar().getTradingDays();
        if (spec.isUsingAutoModel()) {
            this.scontroller = new SeasonalityController();
            this.controllers.add(new RegularUnderDifferencingTest());
            this.controllers.add(new SeasonalUnderDifferencingTest());
            if (spec.getAutoModel().isAmiCompare()) {
                this.controllers.add(new ModelBenchmarking());
            }
            if (td.isAutomatic()) {
                this.controllers.add(new TradingDaysController(TramoModelBuilder.td(spec, DayClustering.TD2, this.modellingContext), td.getProbabilityForFTest()));
            }
            this.controllers.add(new SeasonalUnderDifferencingTest2());
            this.controllers.add(new RegularUnderDifferencingTest2());
        } else {
            this.scontroller = null;
            if (td.isAutomatic()) {
                this.controllers.add(new TradingDaysController(TramoModelBuilder.td(spec, DayClustering.TD2, this.modellingContext), td.getProbabilityForFTest()));
            }
        }
    }

    private static AmiOptions readAmiOptions(TramoSpec spec) {
        AutoModelSpec ami = spec.getAutoModel();
        return AmiOptions.builder().precision(spec.getEstimate().getTol()).ur(spec.getEstimate().getUbp()).va(spec.getOutliers().getCriticalValue()).reduceVa(ami.getPc()).checkMu(spec.isUsingAutoModel() || spec.getRegression().getMean().isTest()).ljungBoxLimit(ami.getPcr()).acceptAirline(ami.isAcceptDefault()).build();
    }

    private ITradingDaysVariable[] alltd() {
        return new ITradingDaysVariable[]{TramoModelBuilder.td(this.spec, DayClustering.TD2, this.modellingContext), TramoModelBuilder.td(this.spec, DayClustering.TD2c, this.modellingContext), TramoModelBuilder.td(this.spec, DayClustering.TD3, this.modellingContext), TramoModelBuilder.td(this.spec, DayClustering.TD3c, this.modellingContext), TramoModelBuilder.td(this.spec, DayClustering.TD4, this.modellingContext), TramoModelBuilder.td(this.spec, DayClustering.TD7, this.modellingContext)};
    }

    private ITradingDaysVariable[] nestedtd() {
        return new ITradingDaysVariable[]{TramoModelBuilder.td(this.spec, DayClustering.TD2, this.modellingContext), TramoModelBuilder.td(this.spec, DayClustering.TD3, this.modellingContext), TramoModelBuilder.td(this.spec, DayClustering.TD4, this.modellingContext), TramoModelBuilder.td(this.spec, DayClustering.TD7, this.modellingContext)};
    }

    private IRegressionModule regressionModule(boolean preadjusted) {
        ILengthOfPeriodVariable lp;
        TradingDaysSpec tdspec = this.spec.getRegression().getCalendar().getTradingDays();
        EasterSpec espec = this.spec.getRegression().getCalendar().getEaster();
        ILengthOfPeriodVariable iLengthOfPeriodVariable = lp = preadjusted ? null : TramoModelBuilder.leapYear(tdspec);
        if (tdspec.isAutomatic()) {
            switch (tdspec.getAutomaticMethod()) {
                case FTEST: {
                    return AutomaticFRegressionTest.builder().easter(espec.isTest() ? TramoModelBuilder.easter(this.spec) : null).leapYear(lp).adjust(tdspec.isAutoAdjust()).tradingDays(TramoModelBuilder.td(this.spec, DayClustering.TD7, this.modellingContext)).workingDays(TramoModelBuilder.td(this.spec, DayClustering.TD2, this.modellingContext)).testMean(this.options.isCheckMu()).fPValue(tdspec.getProbabilityForFTest()).estimationPrecision(this.options.intermediatePrecision).build();
                }
                case AIC: {
                    return AutomaticRegressionTest.builder().easter(espec.isTest() ? TramoModelBuilder.easter(this.spec) : null).leapYear(lp).tradingDays(this.alltd()).testMean(this.options.isCheckMu()).estimationPrecision(this.options.intermediatePrecision).adjust(tdspec.isAutoAdjust()).aic().build();
                }
                case BIC: {
                    return AutomaticRegressionTest.builder().easter(espec.isTest() ? TramoModelBuilder.easter(this.spec) : null).leapYear(lp).adjust(tdspec.isAutoAdjust()).tradingDays(this.alltd()).testMean(this.options.isCheckMu()).estimationPrecision(this.options.intermediatePrecision).bic().build();
                }
            }
            return AutomaticWaldRegressionTest.builder().easter(espec.isTest() ? TramoModelBuilder.easter(this.spec) : null).leapYear(lp).tradingDays(this.nestedtd()).testMean(this.options.isCheckMu()).estimationPrecision(this.options.intermediatePrecision).pconstraint(0.1).pmodel(tdspec.getProbabilityForFTest()).adjust(tdspec.isAutoAdjust()).build();
        }
        return DefaultRegressionTest.builder().easter(espec.isTest() ? TramoModelBuilder.easter(this.spec) : null).leapYear((ILengthOfPeriodVariable)(tdspec.isTest() ? lp : null)).tradingDays(tdspec.isTest() ? TramoModelBuilder.tradingDays(this.spec, this.modellingContext) : null).useJoinTest(tdspec.getRegressionTestType() == RegressionTestType.Joint_F).testMean(this.options.isCheckMu()).estimationPrecision(this.options.intermediatePrecision).adjust(tdspec.isAutoAdjust()).build();
    }

    private OutliersDetectionModule outliersModule() {
        OutlierSpec outliers = this.spec.getOutliers();
        return OutliersDetectionModule.builder().ao(outliers.isAo()).ls(outliers.isLs()).tc(outliers.isTc()).so(outliers.isSo()).span(outliers.getSpan()).tcrate(outliers.getDeltaTC()).maximumLikelihood(outliers.isMaximumLikelihood()).precision(this.options.intermediatePrecision).build();
    }

    private OutliersDetectionModule robustOutliersModule() {
        return OutliersDetectionModule.builder().ao(true).ls(true).precision(0.001).build();
    }

    private DifferencingModule differencingModule() {
        AutoModelSpec amiSpec = this.spec.getAutoModel();
        return DifferencingModule.builder().cancel(amiSpec.getCancel()).ub1(amiSpec.getUb1()).ub2(amiSpec.getUb2()).seasonal(this.context.seasonal).precision(this.options.intermediatePrecision).initial(this.round == 1).build();
    }

    private ArmaModule armaModule() {
        return ArmaModule.builder().seasonal(this.context.seasonal).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegSarimaModel process(TsData originalTs, ProcessingLog log) {
        if (log == null) {
            log = ProcessingLog.dummy();
        }
        log.push(TRAMO);
        try {
            RegSarimaModel rslt;
            ModelDescription desc = this.build(originalTs, log);
            if (desc == null) {
                log.error("initialization failed");
                RegSarimaModel regSarimaModel = null;
                return regSarimaModel;
            }
            RegSarimaModelling modelling = RegSarimaModelling.of((ModelDescription)desc, (ProcessingLog)log);
            RegSarimaModel regSarimaModel = rslt = this.ami(modelling);
            return regSarimaModel;
        }
        finally {
            log.pop();
        }
    }

    private ModelDescription build(TsData originalTs, ProcessingLog log) {
        TramoModelBuilder builder = new TramoModelBuilder(this.spec, this.modellingContext);
        return builder.build(originalTs, log);
    }

    private boolean isFullySpecified() {
        return this.spec.getTransform().getFunction() != TransformationType.Auto && !this.isAutoModelling() && !this.isOutliersDetection() && !this.spec.getRegression().getMean().isTest() && !this.spec.getRegression().getCalendar().getTradingDays().isTest() && !this.spec.getRegression().getCalendar().getTradingDays().isAutomatic() && !this.spec.getRegression().getCalendar().getEaster().isTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegSarimaModel ami(RegSarimaModelling modelling) {
        if (this.isFullySpecified()) {
            modelling.estimate(this.options.precision);
            return modelling.build();
        }
        modelling.getLog().push(AMI);
        try {
            this.testSeasonality(modelling);
            if (!this.testTransformation(modelling)) {
                RegSarimaModel regSarimaModel = null;
                return regSarimaModel;
            }
            this.regressionModule(modelling.getDescription().isAdjusted()).test(modelling);
            this.initProcessing(modelling.getDescription().regarima().getActualObservationsCount());
            int iter = 0;
            while (++iter < 10 && !this.iterate(modelling)) {
            }
            RegSarimaModel regSarimaModel = modelling.build();
            return regSarimaModel;
        }
        finally {
            modelling.getLog().pop();
        }
    }

    private void initProcessing(int n) {
        this.round = 0;
        this.pass = 0;
        this.pass3 = false;
        this.needOutliers = this.isOutliersDetection();
        this.needAutoModelling = false;
        if (this.isOutliersDetection()) {
            this.curva = this.options.getVa();
            if (this.curva == 0.0) {
                this.curva = TramoUtility.calcCv(n);
            }
        }
        this.pcr = this.options.ljungBoxLimit;
        this.refAuto = null;
        this.refStats = null;
        if (this.scontroller != null) {
            this.scontroller.setReferenceModel(null);
        }
        this.controllers.forEach(c -> c.setReferenceModel(null));
    }

    private boolean reduceVa() {
        if (this.curva == 2.0) {
            return false;
        }
        this.curva = Math.max(2.0, this.curva * (1.0 - this.options.reduceVa));
        return true;
    }

    private boolean iterate(RegSarimaModelling modelling) {
        modelling.getLog().step(ROUND + this.pass);
        if (modelling.needEstimation()) {
            modelling.estimate(this.options.getIntermediatePrecision());
        }
        ModelDescription desc = modelling.getDescription();
        boolean changed = false;
        SarimaOrders curspec = desc.specification();
        boolean curMean = desc.isMean();
        if (this.needDifferencing(desc)) {
            changed = this.execDifferencing(modelling) == ProcessingResult.Changed;
            SarimaOrders nspec = desc.specification();
            if (this.pass == 1 && nspec.getDifferenceOrder() != curspec.getDifferenceOrder()) {
                desc.removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
                modelling.clearEstimation();
            }
        }
        if (this.needAutoModelling(desc)) {
            this.execAutoModelling(modelling);
            desc = modelling.getDescription();
            boolean bl = changed = !desc.specification().equals((Object)curspec) || desc.isMean() != curMean;
        }
        if (this.needOutliers(desc)) {
            if (modelling.getDescription().removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true))) {
                modelling.clearEstimation();
            }
            ProcessingResult rslt = this.execOutliers(modelling);
            boolean bl = changed = changed || rslt == ProcessingResult.Changed;
        }
        if (!this.estimateModel(modelling)) {
            this.needOutliers = this.isOutliersDetection();
            this.needAutoModelling = this.isAutoModelling();
            ++this.round;
            ++this.pass;
            return false;
        }
        if (this.round == 0 && (this.isAutoModelling() || this.isOutliersDetection())) {
            this.needOutliers = this.isOutliersDetection();
            this.needAutoModelling = this.isAutoModelling();
            ++this.round;
            ++this.pass;
            RegSarimaModelling.copyOf((RegSarimaModelling)modelling);
            this.refAuto = RegSarimaModelling.copyOf((RegSarimaModelling)modelling);
            this.refStats = ModelStatistics.of(this.refAuto.getDescription(), (ConcentratedLikelihood)this.refAuto.getEstimation().getConcentratedLikelihood());
            double lb = this.refStats.getLjungBoxPvalue();
            return this.options.acceptAirline && 1.0 - lb < this.options.ljungBoxLimit;
        }
        if (this.pass <= 3 && !this.pass3 && this.isAutoModelling() && !this.pass2(!changed, modelling)) {
            return false;
        }
        if (!this.testRegression(modelling, this.spec.getAutoModel().getTsig())) {
            this.pass = 4;
            this.needAutoModelling = false;
            this.needOutliers = false;
            return false;
        }
        ModelEstimator estimator = new ModelEstimator(this.options.precision, this.curva, this.outliersModule());
        if (this.spec.isUsingAutoModel()) {
            this.scontroller.setEstimator(estimator);
            if (this.scontroller.process(modelling, this.context) == ProcessingResult.Changed && !this.pass3) {
                this.pass3 = true;
                this.pass = 1;
                this.needAutoModelling = true;
                this.needOutliers = this.isOutliersDetection();
                return false;
            }
        }
        for (ModelController controller : this.controllers) {
            controller.setEstimator(estimator);
            controller.setReferenceModel(this.refAuto);
            controller.process(modelling, this.context);
        }
        return true;
    }

    private boolean needDifferencing(ModelDescription desc) {
        if (!this.needAutoModelling) {
            return false;
        }
        if (this.round == 2 && !desc.variables().anyMatch(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true))) {
            return false;
        }
        SarimaOrders curspec = desc.specification();
        return curspec.getD() < 2 || curspec.getBd() < 1;
    }

    private boolean isAutoModelling() {
        return this.spec.isUsingAutoModel();
    }

    private boolean isOutliersDetection() {
        return this.spec.getOutliers().isUsed();
    }

    private boolean needOutliers(ModelDescription desc) {
        if (!this.isOutliersDetection()) {
            return false;
        }
        return this.needOutliers;
    }

    private boolean needAutoModelling(ModelDescription desc) {
        if (!this.needAutoModelling) {
            return false;
        }
        return this.round != 2 || desc.variables().anyMatch(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
    }

    private ProcessingResult execDifferencing(RegSarimaModelling context) {
        return this.differencingModule().process(context);
    }

    private ProcessingResult execAutoModelling(RegSarimaModelling context) {
        ProcessingResult rslt = this.armaModule().process(context);
        ModelDescription desc = context.getDescription();
        SarimaOrders curspec = desc.specification();
        if (curspec.getParametersCount() == 0 && this.pass >= 3) {
            curspec.setQ(1);
            desc.setSpecification(curspec);
        }
        return rslt;
    }

    private ProcessingResult execOutliers(RegSarimaModelling context) {
        return this.outliersModule().process(context, this.curva);
    }

    private void restore(RegSarimaModelling context) {
        context.set(ModelDescription.copyOf((ModelDescription)this.refAuto.getDescription()), this.refAuto.getEstimation());
    }

    protected boolean pass2(boolean same, RegSarimaModelling context) {
        double fct = 1.0;
        double fct2 = 1.0;
        boolean useprev = false;
        SarimaModel curmodel = context.getDescription().arima();
        SarimaOrders curspec = curmodel.orders();
        ModelStatistics stats = ModelStatistics.of(context.getDescription(), (ConcentratedLikelihood)context.getEstimation().getConcentratedLikelihood());
        double plbox = 1.0 - stats.getLjungBoxPvalue();
        double rvr = stats.getSe();
        if (this.refAuto != null) {
            double plbox0 = 1.0 - this.refStats.getLjungBoxPvalue();
            double rvr0 = this.refStats.getSe();
            int nout = context.getDescription().countRegressors(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
            int refout = this.refAuto.getDescription().countRegressors(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
            if (refout <= nout && (plbox < 0.95 && plbox0 < 0.75 && rvr0 < rvr || this.pass == 1 && plbox >= 0.95 && plbox0 < 0.95 || plbox < 0.95 && plbox0 < 0.75 && plbox0 < plbox && rvr0 < fct * rvr || plbox >= 0.95 && plbox0 < 0.95 && rvr0 < fct2 * rvr || curspec.getD() == 0 && curspec.getBd() == 1 && curspec.getP() == 1 && curmodel.phi(1) <= -0.82 && curspec.getQ() <= 1 && curspec.getBp() == 0 && curspec.getBq() == 1 || curspec.getD() == 1 && curspec.getBd() == 0 && curspec.getP() == 0 && curspec.getQ() == 1 && curspec.getBp() == 1 && curmodel.bphi(1) <= -0.65 && curspec.getBq() <= 1)) {
                useprev = true;
            }
            if (!useprev) {
                this.refAuto = RegSarimaModelling.copyOf((RegSarimaModelling)context);
                this.refStats = stats;
            } else {
                this.restore(context);
                plbox = plbox0;
            }
        } else {
            this.refAuto = RegSarimaModelling.copyOf((RegSarimaModelling)context);
            this.refStats = stats;
        }
        if (this.pass == 1) {
            this.pcr += 0.025;
        } else if (this.pass >= 2) {
            this.pcr += 0.015;
        }
        if (plbox <= this.pcr) {
            return true;
        }
        if (this.pass == 1 && this.isOutliersDetection()) {
            this.reduceVa();
            context.getLog().remark(OUTLIERS_VA_REDUCED);
        }
        ++this.round;
        ++this.pass;
        if (this.pass <= 2) {
            this.needAutoModelling = !same;
            this.needOutliers = this.isOutliersDetection();
        } else {
            this.lastSolution(context);
            this.needAutoModelling = false;
        }
        return false;
    }

    private void lastSolution(RegSarimaModelling modelling) {
        ModelDescription desc = modelling.getDescription();
        SarimaOrders nspec = desc.specification();
        nspec.setP(3);
        if (nspec.getBd() > 0) {
            nspec.setBp(0);
        }
        nspec.setQ(1);
        if (this.context.seasonal) {
            nspec.setBq(1);
        }
        desc.removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
        modelling.setSpecification(nspec);
        modelling.getLog().warning(LAST_CHANCE);
        this.round = 1;
        this.needOutliers = this.isOutliersDetection();
        this.needAutoModelling = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSeasonality(RegSarimaModelling modelling) {
        ModelDescription model = modelling.getDescription();
        if (!this.isAutoModelling()) {
            this.context.seasonal = model.specification().isSeasonal();
            return;
        }
        int period = model.getAnnualFrequency();
        if (period > 1) {
            ProcessingLog log = modelling.getLog();
            try {
                log.push(SEAS);
                TramoSeasonalityDetector seas = new TramoSeasonalityDetector();
                SeasonalityDetector.Seasonality s = seas.hasSeasonality(model.getTransformedSeries().getValues(), period);
                this.context.originalSeasonalityTest = s.toInt();
                if (this.context.originalSeasonalityTest < 2) {
                    log.remark(NO_SEAS);
                    SarimaOrders nspec = SarimaOrders.m011((int)period);
                    model.setSpecification(nspec);
                    this.context.seasonal = false;
                }
                log.info(this.context.originalSeasonalityTest == 2 ? HAS_SEAS2 : HAS_SEAS3);
                this.context.seasonal = true;
            }
            finally {
                log.pop();
            }
        } else {
            this.context.seasonal = false;
        }
    }

    private boolean testTransformation(RegSarimaModelling modelling) {
        TransformSpec tspec = this.spec.getTransform();
        if (tspec.getFunction() == TransformationType.Auto) {
            boolean toClean = false;
            if (tspec.isOutliersCorrection()) {
                OutliersDetectionModule outliers = this.robustOutliersModule();
                ProcessingResult rslt = outliers.process(modelling, 5.0);
                toClean = rslt == ProcessingResult.Changed;
            }
            LogLevelModule module = LogLevelModule.builder().logPreference(Math.log(tspec.getFct())).estimationPrecision(this.options.intermediatePrecision).seasonal(this.context.seasonal).build();
            module.process(modelling);
            ModelDescription desc = modelling.getDescription();
            if (toClean && desc.removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true))) {
                modelling.clearEstimation();
            }
        } else if (modelling.getDescription().isLogTransformation() && modelling.getDescription().getSeries().getValues().anyMatch(x -> x <= 0.0)) {
            modelling.getLog().error(LOGNEG);
            return false;
        }
        return true;
    }

    private boolean estimateModel(RegSarimaModelling context) {
        FinalEstimator estimator = FinalEstimator.builder().precision(this.options.precision).unitRootThreshold(this.options.ur).pass(this.pass).ami(this.isAutoModelling()).outliers(this.isOutliersDetection()).build();
        int niter = 0;
        do {
            if (!estimator.estimate(context)) {
                if (this.pass == 1 && this.needOutliers(context.getDescription()) && this.needAutoModelling(context.getDescription())) {
                    this.reduceVa();
                }
                return false;
            }
            if (!this.pass3 && this.pass == 0) continue;
            return true;
        } while (niter++ < 5 && !this.testRegression(context, 1.96));
        return true;
    }

    private boolean testRegression(RegSarimaModelling context, double tmean) {
        FastRegressionTest regtest = FastRegressionTest.builder().testMean(this.options.checkMu).meanThreshold(tmean).build();
        return regtest.test(context) == ProcessingResult.Unchanged;
    }

    public static final class AmiOptions {
        private final boolean checkMu;
        private final double precision;
        private final double intermediatePrecision;
        private final double ur;
        private final double va;
        private final double reduceVa;
        private final double ljungBoxLimit;
        private final boolean acceptAirline;

        public static Builder builder() {
            return new Builder().intermediatePrecision(1.0E-5).precision(1.0E-7).ur(0.96).reduceVa(0.12).ljungBoxLimit(0.95);
        }

        @Generated
        AmiOptions(boolean checkMu, double precision, double intermediatePrecision, double ur, double va, double reduceVa, double ljungBoxLimit, boolean acceptAirline) {
            this.checkMu = checkMu;
            this.precision = precision;
            this.intermediatePrecision = intermediatePrecision;
            this.ur = ur;
            this.va = va;
            this.reduceVa = reduceVa;
            this.ljungBoxLimit = ljungBoxLimit;
            this.acceptAirline = acceptAirline;
        }

        @Generated
        public boolean isCheckMu() {
            return this.checkMu;
        }

        @Generated
        public double getPrecision() {
            return this.precision;
        }

        @Generated
        public double getIntermediatePrecision() {
            return this.intermediatePrecision;
        }

        @Generated
        public double getUr() {
            return this.ur;
        }

        @Generated
        public double getVa() {
            return this.va;
        }

        @Generated
        public double getReduceVa() {
            return this.reduceVa;
        }

        @Generated
        public double getLjungBoxLimit() {
            return this.ljungBoxLimit;
        }

        @Generated
        public boolean isAcceptAirline() {
            return this.acceptAirline;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmiOptions)) {
                return false;
            }
            AmiOptions other = (AmiOptions)o;
            if (this.isCheckMu() != other.isCheckMu()) {
                return false;
            }
            if (Double.compare(this.getPrecision(), other.getPrecision()) != 0) {
                return false;
            }
            if (Double.compare(this.getIntermediatePrecision(), other.getIntermediatePrecision()) != 0) {
                return false;
            }
            if (Double.compare(this.getUr(), other.getUr()) != 0) {
                return false;
            }
            if (Double.compare(this.getVa(), other.getVa()) != 0) {
                return false;
            }
            if (Double.compare(this.getReduceVa(), other.getReduceVa()) != 0) {
                return false;
            }
            if (Double.compare(this.getLjungBoxLimit(), other.getLjungBoxLimit()) != 0) {
                return false;
            }
            return this.isAcceptAirline() == other.isAcceptAirline();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCheckMu() ? 79 : 97);
            long $precision = Double.doubleToLongBits(this.getPrecision());
            result = result * 59 + (int)($precision >>> 32 ^ $precision);
            long $intermediatePrecision = Double.doubleToLongBits(this.getIntermediatePrecision());
            result = result * 59 + (int)($intermediatePrecision >>> 32 ^ $intermediatePrecision);
            long $ur = Double.doubleToLongBits(this.getUr());
            result = result * 59 + (int)($ur >>> 32 ^ $ur);
            long $va = Double.doubleToLongBits(this.getVa());
            result = result * 59 + (int)($va >>> 32 ^ $va);
            long $reduceVa = Double.doubleToLongBits(this.getReduceVa());
            result = result * 59 + (int)($reduceVa >>> 32 ^ $reduceVa);
            long $ljungBoxLimit = Double.doubleToLongBits(this.getLjungBoxLimit());
            result = result * 59 + (int)($ljungBoxLimit >>> 32 ^ $ljungBoxLimit);
            result = result * 59 + (this.isAcceptAirline() ? 79 : 97);
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "TramoKernel.AmiOptions(checkMu=" + this.isCheckMu() + ", precision=" + this.getPrecision() + ", intermediatePrecision=" + this.getIntermediatePrecision() + ", ur=" + this.getUr() + ", va=" + this.getVa() + ", reduceVa=" + this.getReduceVa() + ", ljungBoxLimit=" + this.getLjungBoxLimit() + ", acceptAirline=" + this.isAcceptAirline() + ")";
        }

        @Generated
        public static class Builder {
            @Generated
            private boolean checkMu;
            @Generated
            private double precision;
            @Generated
            private double intermediatePrecision;
            @Generated
            private double ur;
            @Generated
            private double va;
            @Generated
            private double reduceVa;
            @Generated
            private double ljungBoxLimit;
            @Generated
            private boolean acceptAirline;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder checkMu(boolean checkMu) {
                this.checkMu = checkMu;
                return this;
            }

            @Generated
            public @NonNull Builder precision(double precision) {
                this.precision = precision;
                return this;
            }

            @Generated
            public @NonNull Builder intermediatePrecision(double intermediatePrecision) {
                this.intermediatePrecision = intermediatePrecision;
                return this;
            }

            @Generated
            public @NonNull Builder ur(double ur) {
                this.ur = ur;
                return this;
            }

            @Generated
            public @NonNull Builder va(double va) {
                this.va = va;
                return this;
            }

            @Generated
            public @NonNull Builder reduceVa(double reduceVa) {
                this.reduceVa = reduceVa;
                return this;
            }

            @Generated
            public @NonNull Builder ljungBoxLimit(double ljungBoxLimit) {
                this.ljungBoxLimit = ljungBoxLimit;
                return this;
            }

            @Generated
            public @NonNull Builder acceptAirline(boolean acceptAirline) {
                this.acceptAirline = acceptAirline;
                return this;
            }

            @Generated
            public @NonNull AmiOptions build() {
                return new AmiOptions(this.checkMu, this.precision, this.intermediatePrecision, this.ur, this.va, this.reduceVa, this.ljungBoxLimit, this.acceptAirline);
            }

            @Generated
            public @NonNull String toString() {
                return "TramoKernel.AmiOptions.Builder(checkMu=" + this.checkMu + ", precision=" + this.precision + ", intermediatePrecision=" + this.intermediatePrecision + ", ur=" + this.ur + ", va=" + this.va + ", reduceVa=" + this.reduceVa + ", ljungBoxLimit=" + this.ljungBoxLimit + ", acceptAirline=" + this.acceptAirline + ")";
            }
        }
    }
}

