/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.function.Function;
import jdplus.toolkit.base.api.util.TreeTraverser;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.DataSourceProvider;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.function.IOFunction;

public final class TsProviders {
    @NonNull
    public static TreeTraverser<?> getTreeTraverser(@NonNull DataSourceProvider provider, @NonNull DataSource dataSource) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        IOFunction children = o -> o instanceof DataSource ? provider.children((DataSource)o) : (((DataSet)o).getKind() == DataSet.Kind.COLLECTION ? provider.children((DataSet)o) : Collections.emptyList());
        return TreeTraverser.of((Object)dataSource, (Function)children.asUnchecked());
    }

    public static void prettyPrintTree(@NonNull DataSourceProvider provider, @NonNull DataSource dataSource, int maxLevel, @NonNull PrintStream printStream, boolean displayName) throws IOException {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (printStream == null) {
            throw new NullPointerException("printStream is marked non-null but is null");
        }
        Function<Object, String> formatter = displayName ? o -> o instanceof DataSource ? provider.getDisplayName((DataSource)o) : " " + provider.getDisplayNodeName((DataSet)o) : o -> o instanceof DataSource ? provider.toMoniker((DataSource)o).getId() : " " + provider.toMoniker((DataSet)o).getId();
        try {
            TsProviders.getTreeTraverser(provider, dataSource).prettyPrintTo((Appendable)printStream, maxLevel, formatter);
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    @Generated
    private TsProviders() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

