% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_launcher.R
\name{make_launcher}
\alias{make_launcher}
\title{Create a Startup Script to Launch an Editor Inside a Nix Shell}
\usage{
make_launcher(editor, project_path)
}
\arguments{
\item{editor}{Character, the command to launch the editor. See the "Details" section below for more information.}

\item{project_path}{Character, where to write the launcher, for example
"/home/path/to/project". The file will thus be written to the file
"/home/path/to/project/start-editor.sh". If the folder does not exist, it will
be created.}
}
\value{
Nothing, writes a script.
}
\description{
Create a Startup Script to Launch an Editor Inside a Nix Shell
}
\details{
This function will write a launcher to start an IDE inside of a
Nix shell. With a launcher, you only need to execute it instead of first
having to drop into the shell using \code{nix-shell} and then type the command
to run the IDE. For security reasons, this script is not executable upon
creation, so you need to make it executable first by running
\verb{chmod +x start-editor.sh} (replace \code{editor} with whichever editor you use).
You don’t need this launcher if you use \code{direnv};
see \code{vignette("configuring-ide")} for more details.
}
\examples{
available_dates()
}
