% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pubmed_data.R
\name{get_pubmed_count}
\alias{get_pubmed_count}
\title{Get Total Number of PubMed Articles for a Search Term}
\usage{
get_pubmed_count(package_name, api_key = getOption("pubmed.api_key", NULL))
}
\arguments{
\item{package_name}{A character string representing the search term (e.g., an R package name).}

\item{api_key}{Optional. A character string with an NCBI API key. If not supplied,
it will attempt to use the option \code{getOption("pubmed.api_key")}.}
}
\value{
An integer representing the total number of PubMed articles matching the search term, 
or \code{NA} if the request fails.
}
\description{
This function queries the NCBI E-utilities API to retrieve the total number of 
PubMed articles that match a given search term or R package name.
}
\examples{
\dontrun{
get_pubmed_count("ggplot2")
}

}
