% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{dependsOnPkgs}
\alias{dependsOnPkgs}
\title{Determine Packages that Depend on Given Packages}
\usage{
dependsOnPkgs(
  pkgs,
  dependencies = "most",
  recursive = TRUE,
  lib.loc = NULL,
  installed = NULL
)
}
\arguments{
\item{pkgs}{A character vector of package names to check dependencies for.}

\item{dependencies}{A character string specifying the types of dependencies
to consider. Can be "strong", "most", "all", or a custom vector of dependency types.}

\item{recursive}{A logical value indicating whether to recursively check dependencies.}

\item{lib.loc}{A character vector of library locations to search for installed packages.}

\item{installed}{A matrix of installed packages, obtained from cran_packages function.
.}
}
\value{
A character vector of package names that depend on the specified packages.
}
\description{
This function identifies packages that depend on the specified packages,
considering various types of dependencies (e.g., strong, most, all).
}
\examples{
\dontrun{
installed <- cran_packages()
dependsOnPkgs("here", installed = installed)
}

}
