% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPT2.R
\name{matchCall2}
\alias{matchCall2}
\title{Remove \code{quote} and determine if call uses \code{...}}
\usage{
matchCall2(definition, call, envir, envir2 = parent.frame(), FUN)
}
\arguments{
\item{definition}{a function, by default the function from which
    \code{match.call} is called.  See details.}

\item{call}{an unevaluated call to the function specified by
    \code{definition}, as generated by \code{\link[base]{call}}.}

\item{envir}{an environment, from which the \code{\dots} in \code{call}
    are retrieved, if any.}

\item{envir2}{Environment. The environment where \code{matchCall2} was called.}

\item{FUN}{Either a function (e.g., \code{rnorm}), a function call (e.g., \code{rnorm(1)}),
or an unevaluated function call (e.g., using \code{quote()}).}
}
\value{
A named list with \code{call} (the original call, without \code{quote}),
\code{FUNorig}, the original value passed by user to \code{FUN}, and \code{usesDots} which
is a logical indicating whether the \code{...} are used.
}
\description{
Minor cleaning up of the \code{FUN} and \code{...} to be used subsequently. This does only very minor
things as it is run even if \code{useCache = FALSE}, i.e., even if the \code{Cache} is skipped.
}
