% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_clicks.R
\name{add_clicks}
\alias{add_clicks}
\title{Add clicks to subdistribution curves for reconstructing CIC}
\usage{
add_clicks(clicksDF, targetTimes, nAdd)
}
\arguments{
\item{clicksDF}{A data frame with the two columns, time and cuminc.}

\item{targetTimes}{A vector of times from the composite KM plot.}

\item{nAdd}{Number of times to add to clicksDF.}
}
\value{
An augmented clicksDF with extra rows (no cuminc jumps in those extra times).
}
\description{
When there are more clicks in the composite (overall) outcome curve,
we need to add them to the subdistribution curves. Find the time points
in the composite data that are furthest away from the times in clicksDF,
add these times to clicksDF with 0 jumps in cuminc.
}
\examples{
clicksDF <- data.frame(time=0:10, cuminc=seq(from=0, to=1, by=0.1))
add_clicks(clicksDF, targetTimes = runif(n=14, min=0, max=10), nAdd=5)
}
