% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairedSampleDominance.r
\name{pairedSampleDominance}
\alias{pairedSampleDominance}
\title{Dominance statistic for two-sample paired data}
\usage{
pairedSampleDominance(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{formula}{A formula indicating the response variable and
the independent variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{If no formula is given, the response variable for one group.}

\item{y}{The response variable for the other group.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{na.rm}{If \code{TRUE}, removes \code{NA} values from
the input vectors or data frame.}

\item{...}{Additional arguments.}
}
\value{
A small data frame consisting of descriptive statistics,
        the dominance statistic,
        and potentially the lower and upper confidence limits.
}
\description{
Calculates a dominance
             effect size statistic
             for two-sample paired data
             with confidence intervals by bootstrap
}
\details{
The calculated \code{Dominance} statistic is simply 
         the proportion of observations in \code{x} greater the paired
         observations in \code{y},
         minus
         the proportion of observations in \code{x} less than the paired
         observations in \code{y}
         
         It will range from -1 to 1, with
         and 1 indicating that 
         the all the observations in \code{x} are greater than 
         the paired observations in \code{y},
         and -1 indicating that
         the all the observations in \code{y} are greater than 
         the paired observations in \code{x}.
         
         The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{y}. If there are more than two groups,
         only the first two groups are used.
         
         This statistic is appropriate for truly ordinal data,
         and could be considered an effect size statistic for
         a two-sample paired sign test.
         
         Ordered category data need to re-coded as
         numeric, e.g. as with \code{as.numeric(Ordinal.variable)}.

         When the statistic is close to 1 or close to -1,
         or with small sample size,
         the confidence intervals 
         determined by this
         method may not be reliable, or the procedure may fail.
          
         VDA is the analogous statistic, converted to a probability,
         ranging from 0 to 1, specifically,
         \code{VDA = Dominance / 2 + 0.5}
}
\examples{
data(Pooh)
Time.1 = Pooh$Likert[Pooh$Time == 1]
Time.2 = Pooh$Likert[Pooh$Time == 2]
library(DescTools)
SignTest(x = Time.1, y = Time.2)
pairedSampleDominance(x = Time.1, y = Time.2)
pairedSampleDominance(Likert ~ Time, data=Pooh)

}
\references{
\url{https://rcompanion.org/handbook/F_07.html}
}
\seealso{
\code{\link{oneSampleDominance}},
         \code{\link{vda}},
         \code{\link{cliffDelta}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{dominance}
\concept{effect size}
\concept{sign test}
